/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests.testmodel;

import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.tests.testmodel.MyServiceException;

public class MyServiceExceptionMessageCodec
implements MessageCodec<MyServiceException, MyServiceException> {
    public void encodeToWire(Buffer buffer, MyServiceException body) {
        byte[] encoded;
        buffer.appendInt(body.failureCode());
        if (body.getMessage() == null) {
            buffer.appendByte((byte)0);
        } else {
            buffer.appendByte((byte)1);
            encoded = body.getMessage().getBytes(CharsetUtil.UTF_8);
            buffer.appendInt(encoded.length);
            buffer.appendBytes(encoded);
        }
        if (body.getExtra() == null) {
            buffer.appendByte((byte)0);
        } else {
            buffer.appendByte((byte)1);
            encoded = body.getExtra().getBytes(CharsetUtil.UTF_8);
            buffer.appendInt(encoded.length);
            buffer.appendBytes(encoded);
        }
        body.getDebugInfo().writeToBuffer(buffer);
    }

    public MyServiceException decodeFromWire(int pos, Buffer buffer) {
        String extra;
        String message;
        int failureCode = buffer.getInt(pos);
        boolean isNull = buffer.getByte(pos += 4) == 0;
        ++pos;
        if (!isNull) {
            int strLength = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + strLength);
            pos += strLength;
            message = new String(bytes, CharsetUtil.UTF_8);
        } else {
            message = null;
        }
        isNull = buffer.getByte(pos) == 0;
        ++pos;
        if (!isNull) {
            int strLength = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + strLength);
            extra = new String(bytes, CharsetUtil.UTF_8);
            pos += strLength;
        } else {
            extra = null;
        }
        JsonObject debugInfo = new JsonObject();
        debugInfo.readFromBuffer(pos, buffer);
        return new MyServiceException(failureCode, message, debugInfo, extra);
    }

    public MyServiceException transform(MyServiceException e) {
        return e;
    }

    public String name() {
        return "myServiceException";
    }

    public byte systemCodecID() {
        return -1;
    }
}

