/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests.testmodel;

import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.ProxyIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceProxyBuilder;
import io.vertx.serviceproxy.tests.testmodel.SomeEnum;
import io.vertx.serviceproxy.tests.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.tests.testmodel.TestConnection;
import io.vertx.serviceproxy.tests.testmodel.TestDataObject;
import io.vertx.serviceproxy.tests.testmodel.impl.TestServiceImpl;
import io.vertx.serviceproxy.tests.testmodel.sub.TestSubConnection;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProxyGen
@VertxGen
public interface TestService {
    public static TestService create(Vertx vertx) throws Exception {
        return new TestServiceImpl(vertx);
    }

    public static TestService createProxy(Vertx vertx, String address) {
        return (TestService)new ServiceProxyBuilder(vertx).setAddress(address).build(TestService.class);
    }

    public static TestService createProxyLongDelivery(Vertx vertx, String address) {
        DeliveryOptions options = new DeliveryOptions();
        options.setSendTimeout(20000L);
        return (TestService)new ServiceProxyBuilder(vertx).setAddress(address).setOptions(options).build(TestService.class);
    }

    public static TestService createProxyWithOptions(Vertx vertx, String address, DeliveryOptions options) {
        return (TestService)new ServiceProxyBuilder(vertx).setAddress(address).setOptions(options).build(TestService.class);
    }

    public Future<String> longDeliverySuccess();

    public Future<String> longDeliveryFailed();

    public Future<TestConnection> createConnection(String var1);

    public Future<TestSubConnection> createSubConnection(String var1);

    public void noParams();

    public void basicTypes(String var1, byte var2, short var3, int var4, long var5, float var7, double var8, char var10, boolean var11);

    public void basicBoxedTypes(String var1, Byte var2, Short var3, Integer var4, Long var5, Float var6, Double var7, Character var8, Boolean var9);

    public void basicBoxedTypesNull(String var1, Byte var2, Short var3, Integer var4, Long var5, Float var6, Double var7, Character var8, Boolean var9);

    public void jsonTypes(JsonObject var1, JsonArray var2);

    public void jsonTypesNull(JsonObject var1, JsonArray var2);

    public void enumType(SomeEnum var1);

    public void enumTypeNull(SomeEnum var1);

    public Future<SomeEnum> enumTypeAsResult();

    public Future<SomeEnum> enumTypeAsResultNull();

    public void enumCustomType(SomeEnumWithCustomConstructor var1);

    public void enumCustomTypeNull(SomeEnumWithCustomConstructor var1);

    public Future<SomeEnumWithCustomConstructor> enumCustomTypeAsResult();

    public Future<SomeEnumWithCustomConstructor> enumCustomTypeAsResultNull();

    public void dataObjectType(TestDataObject var1);

    public void listdataObjectType(List<TestDataObject> var1);

    public void setdataObjectType(Set<TestDataObject> var1);

    public void dataObjectTypeNull(TestDataObject var1);

    public void dateTimeType(ZonedDateTime var1);

    public void listDateTimeType(List<ZonedDateTime> var1);

    public void setDateTimeType(Set<ZonedDateTime> var1);

    public void mapDateTimeType(Map<String, ZonedDateTime> var1);

    public void listdataObjectTypeHavingNullValues(List<TestDataObject> var1);

    public void setdataObjectTypeHavingNullValues(Set<TestDataObject> var1);

    public void listdataObjectTypeNull(List<TestDataObject> var1);

    public void setdataObjectTypeNull(Set<TestDataObject> var1);

    public void mapDataObjectType(Map<String, TestDataObject> var1);

    public void listParams(List<String> var1, List<Byte> var2, List<Short> var3, List<Integer> var4, List<Long> var5, List<JsonObject> var6, List<JsonArray> var7, List<TestDataObject> var8);

    public void setParams(Set<String> var1, Set<Byte> var2, Set<Short> var3, Set<Integer> var4, Set<Long> var5, Set<JsonObject> var6, Set<JsonArray> var7, Set<TestDataObject> var8);

    public void mapParams(Map<String, String> var1, Map<String, Byte> var2, Map<String, Short> var3, Map<String, Integer> var4, Map<String, Long> var5, Map<String, JsonObject> var6, Map<String, JsonArray> var7);

    public Future<String> stringHandler();

    public Future<String> stringNullHandler();

    public Future<Byte> byteHandler();

    public Future<Byte> byteNullHandler();

    public Future<Short> shortHandler();

    public Future<Short> shortNullHandler();

    public Future<Integer> intHandler();

    public Future<Integer> intNullHandler();

    public Future<Long> longHandler();

    public Future<Long> longNullHandler();

    public Future<Float> floatHandler();

    public Future<Float> floatNullHandler();

    public Future<Double> doubleHandler();

    public Future<Double> doubleNullHandler();

    public Future<Character> charHandler();

    public Future<Character> charNullHandler();

    public Future<Boolean> booleanHandler();

    public Future<Boolean> booleanNullHandler();

    public Future<JsonObject> jsonObjectHandler();

    public Future<JsonObject> jsonObjectNullHandler();

    public Future<JsonArray> jsonArrayHandler();

    public Future<JsonArray> jsonArrayNullHandler();

    public Future<TestDataObject> dataObjectHandler();

    public Future<TestDataObject> dataObjectNullHandler();

    public Future<Void> voidHandler();

    public Future<JsonObject> failingMethod();

    public Future<String> invokeWithMessage(JsonObject var1, String var2, int var3, char var4, SomeEnum var5);

    public Future<List<String>> listStringHandler();

    public Future<List<Byte>> listByteHandler();

    public Future<List<Short>> listShortHandler();

    public Future<List<Integer>> listIntHandler();

    public Future<List<Long>> listLongHandler();

    public Future<List<Float>> listFloatHandler();

    public Future<List<Double>> listDoubleHandler();

    public Future<List<Character>> listCharHandler();

    public Future<List<Boolean>> listBoolHandler();

    public Future<List<JsonObject>> listJsonObjectHandler();

    public Future<List<JsonArray>> listJsonArrayHandler();

    public Future<List<TestDataObject>> listDataObjectHandler();

    public Future<Set<String>> setStringHandler();

    public Future<Set<Byte>> setByteHandler();

    public Future<Set<Short>> setShortHandler();

    public Future<Set<Integer>> setIntHandler();

    public Future<Set<Long>> setLongHandler();

    public Future<Set<Float>> setFloatHandler();

    public Future<Set<Double>> setDoubleHandler();

    public Future<Set<Character>> setCharHandler();

    public Future<Set<Boolean>> setBoolHandler();

    public Future<Map<String, String>> mapStringHandler();

    public Future<Map<String, Byte>> mapByteHandler();

    public Future<Map<String, Short>> mapShortHandler();

    public Future<Map<String, Integer>> mapIntHandler();

    public Future<Map<String, Long>> mapLongHandler();

    public Future<Map<String, Float>> mapFloatHandler();

    public Future<Map<String, Double>> mapDoubleHandler();

    public Future<Map<String, Character>> mapCharHandler();

    public Future<Map<String, Boolean>> mapBoolHandler();

    public Future<Set<JsonObject>> setJsonObjectHandler();

    public Future<Map<String, JsonObject>> mapJsonObjectHandler();

    public Future<Set<JsonArray>> setJsonArrayHandler();

    public Future<Map<String, JsonArray>> mapJsonArrayHandler();

    public Future<Set<TestDataObject>> setDataObjectHandler();

    public Future<Map<String, TestDataObject>> mapDataObject();

    public Future<JsonObject> failingCall(String var1);

    public Future<List<TestDataObject>> listDataObjectContainingNullHandler();

    public Future<Set<TestDataObject>> setDataObjectContainingNullHandler();

    public Future<ZonedDateTime> zonedDateTimeHandler();

    public Future<List<ZonedDateTime>> listZonedDateTimeHandler();

    public Future<Set<ZonedDateTime>> setZonedDateTimeHandler();

    public Future<Map<String, ZonedDateTime>> mapZonedDateTimeHandler();

    @ProxyIgnore
    public void ignoredMethod();
}

