/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests.testmodel;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ProxyUtils;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.tests.testmodel.Mappers;
import io.vertx.serviceproxy.tests.testmodel.SomeEnum;
import io.vertx.serviceproxy.tests.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.tests.testmodel.TestConnection;
import io.vertx.serviceproxy.tests.testmodel.TestConnectionVertxEBProxy;
import io.vertx.serviceproxy.tests.testmodel.TestDataObject;
import io.vertx.serviceproxy.tests.testmodel.TestService;
import io.vertx.serviceproxy.tests.testmodel.sub.TestSubConnection;
import io.vertx.serviceproxy.tests.testmodel.sub.TestSubConnectionVertxEBProxy;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TestServiceVertxEBProxy
implements TestService {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public TestServiceVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public TestServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public Future<String> longDeliverySuccess() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "longDeliverySuccess");
        _deliveryOptions.getHeaders().set("action", "longDeliverySuccess");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (String)msg.body());
    }

    @Override
    public Future<String> longDeliveryFailed() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "longDeliveryFailed");
        _deliveryOptions.getHeaders().set("action", "longDeliveryFailed");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (String)msg.body());
    }

    @Override
    public Future<TestConnection> createConnection(String str) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "createConnection");
        _deliveryOptions.getHeaders().set("action", "createConnection");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> new TestConnectionVertxEBProxy(this._vertx, msg.headers().get("proxyaddr")));
    }

    @Override
    public Future<TestSubConnection> createSubConnection(String str) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "createSubConnection");
        _deliveryOptions.getHeaders().set("action", "createSubConnection");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> new TestSubConnectionVertxEBProxy(this._vertx, msg.headers().get("proxyaddr")));
    }

    @Override
    public void noParams() {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "noParams");
        _deliveryOptions.getHeaders().set("action", "noParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void basicTypes(String str, byte b, short s, int i, long l, float f, double d, char c, boolean bool) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        _json.put("b", (Object)b);
        _json.put("s", (Object)s);
        _json.put("i", (Object)i);
        _json.put("l", (Object)l);
        _json.put("f", (Object)Float.valueOf(f));
        _json.put("d", (Object)d);
        _json.put("c", (Object)c);
        _json.put("bool", (Object)bool);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "basicTypes");
        _deliveryOptions.getHeaders().set("action", "basicTypes");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void basicBoxedTypes(String str, Byte b, Short s, Integer i, Long l, Float f, Double d, Character c, Boolean bool) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        _json.put("b", (Object)b);
        _json.put("s", (Object)s);
        _json.put("i", (Object)i);
        _json.put("l", (Object)l);
        _json.put("f", (Object)f);
        _json.put("d", (Object)d);
        _json.put("c", c == null ? null : Integer.valueOf(c.charValue()));
        _json.put("bool", (Object)bool);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "basicBoxedTypes");
        _deliveryOptions.getHeaders().set("action", "basicBoxedTypes");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void basicBoxedTypesNull(String str, Byte b, Short s, Integer i, Long l, Float f, Double d, Character c, Boolean bool) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("str", (Object)str);
        _json.put("b", (Object)b);
        _json.put("s", (Object)s);
        _json.put("i", (Object)i);
        _json.put("l", (Object)l);
        _json.put("f", (Object)f);
        _json.put("d", (Object)d);
        _json.put("c", c == null ? null : Integer.valueOf(c.charValue()));
        _json.put("bool", (Object)bool);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "basicBoxedTypesNull");
        _deliveryOptions.getHeaders().set("action", "basicBoxedTypesNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void jsonTypes(JsonObject jsonObject, JsonArray jsonArray) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("jsonObject", (Object)jsonObject);
        _json.put("jsonArray", (Object)jsonArray);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonTypes");
        _deliveryOptions.getHeaders().set("action", "jsonTypes");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void jsonTypesNull(JsonObject jsonObject, JsonArray jsonArray) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("jsonObject", (Object)jsonObject);
        _json.put("jsonArray", (Object)jsonArray);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonTypesNull");
        _deliveryOptions.getHeaders().set("action", "jsonTypesNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void enumType(SomeEnum someEnum) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("someEnum", (Object)(someEnum == null ? null : someEnum.name()));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumType");
        _deliveryOptions.getHeaders().set("action", "enumType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void enumTypeNull(SomeEnum someEnum) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("someEnum", (Object)(someEnum == null ? null : someEnum.name()));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumTypeNull");
        _deliveryOptions.getHeaders().set("action", "enumTypeNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public Future<SomeEnum> enumTypeAsResult() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumTypeAsResult");
        _deliveryOptions.getHeaders().set("action", "enumTypeAsResult");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() == null ? null : SomeEnum.valueOf((String)msg.body()));
    }

    @Override
    public Future<SomeEnum> enumTypeAsResultNull() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumTypeAsResultNull");
        _deliveryOptions.getHeaders().set("action", "enumTypeAsResultNull");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() == null ? null : SomeEnum.valueOf((String)msg.body()));
    }

    @Override
    public void enumCustomType(SomeEnumWithCustomConstructor someEnum) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("someEnum", (Object)(someEnum != null ? Mappers.serializeSomeEnumWithCustomConstructor(someEnum) : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumCustomType");
        _deliveryOptions.getHeaders().set("action", "enumCustomType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void enumCustomTypeNull(SomeEnumWithCustomConstructor someEnum) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("someEnum", (Object)(someEnum != null ? Mappers.serializeSomeEnumWithCustomConstructor(someEnum) : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumCustomTypeNull");
        _deliveryOptions.getHeaders().set("action", "enumCustomTypeNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public Future<SomeEnumWithCustomConstructor> enumCustomTypeAsResult() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumCustomTypeAsResult");
        _deliveryOptions.getHeaders().set("action", "enumCustomTypeAsResult");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? Mappers.deserializeSomeEnumWithCustomConstructor((String)msg.body()) : null);
    }

    @Override
    public Future<SomeEnumWithCustomConstructor> enumCustomTypeAsResultNull() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "enumCustomTypeAsResultNull");
        _deliveryOptions.getHeaders().set("action", "enumCustomTypeAsResultNull");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? Mappers.deserializeSomeEnumWithCustomConstructor((String)msg.body()) : null);
    }

    @Override
    public void dataObjectType(TestDataObject options) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("options", (Object)(options != null ? options.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectType");
        _deliveryOptions.getHeaders().set("action", "dataObjectType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void listdataObjectType(List<TestDataObject> list) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listdataObjectType");
        _deliveryOptions.getHeaders().set("action", "listdataObjectType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void setdataObjectType(Set<TestDataObject> set) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("set", (Object)new JsonArray(set == null ? Collections.emptyList() : set.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setdataObjectType");
        _deliveryOptions.getHeaders().set("action", "setdataObjectType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void dataObjectTypeNull(TestDataObject options) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("options", (Object)(options != null ? options.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectTypeNull");
        _deliveryOptions.getHeaders().set("action", "dataObjectTypeNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void dateTimeType(ZonedDateTime dateTime) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("dateTime", (Object)(dateTime != null ? Mappers.serializeZonedDateTime(dateTime) : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dateTimeType");
        _deliveryOptions.getHeaders().set("action", "dateTimeType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void listDateTimeType(List<ZonedDateTime> list) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listDateTimeType");
        _deliveryOptions.getHeaders().set("action", "listDateTimeType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void setDateTimeType(Set<ZonedDateTime> set) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("set", (Object)new JsonArray(set == null ? Collections.emptyList() : set.stream().map(v -> v != null ? Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setDateTimeType");
        _deliveryOptions.getHeaders().set("action", "setDateTimeType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void mapDateTimeType(Map<String, ZonedDateTime> map) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("map", (Object)new JsonObject(map == null ? Collections.emptyMap() : map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? Mappers.serializeZonedDateTime((ZonedDateTime)e.getValue()) : null))));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapDateTimeType");
        _deliveryOptions.getHeaders().set("action", "mapDateTimeType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void listdataObjectTypeHavingNullValues(List<TestDataObject> list) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listdataObjectTypeHavingNullValues");
        _deliveryOptions.getHeaders().set("action", "listdataObjectTypeHavingNullValues");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void setdataObjectTypeHavingNullValues(Set<TestDataObject> set) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("set", (Object)new JsonArray(set == null ? Collections.emptyList() : set.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setdataObjectTypeHavingNullValues");
        _deliveryOptions.getHeaders().set("action", "setdataObjectTypeHavingNullValues");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void listdataObjectTypeNull(List<TestDataObject> list) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("list", (Object)new JsonArray(list == null ? Collections.emptyList() : list.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listdataObjectTypeNull");
        _deliveryOptions.getHeaders().set("action", "listdataObjectTypeNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void setdataObjectTypeNull(Set<TestDataObject> set) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("set", (Object)new JsonArray(set == null ? Collections.emptyList() : set.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setdataObjectTypeNull");
        _deliveryOptions.getHeaders().set("action", "setdataObjectTypeNull");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void mapDataObjectType(Map<String, TestDataObject> map) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("map", (Object)new JsonObject(map == null ? Collections.emptyMap() : map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? ((TestDataObject)e.getValue()).toJson() : null))));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapDataObjectType");
        _deliveryOptions.getHeaders().set("action", "mapDataObjectType");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void listParams(List<String> listString, List<Byte> listByte, List<Short> listShort, List<Integer> listInt, List<Long> listLong, List<JsonObject> listJsonObject, List<JsonArray> listJsonArray, List<TestDataObject> listDataObject) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("listString", (Object)new JsonArray(listString));
        _json.put("listByte", (Object)new JsonArray(listByte));
        _json.put("listShort", (Object)new JsonArray(listShort));
        _json.put("listInt", (Object)new JsonArray(listInt));
        _json.put("listLong", (Object)new JsonArray(listLong));
        _json.put("listJsonObject", (Object)new JsonArray(listJsonObject));
        _json.put("listJsonArray", (Object)new JsonArray(listJsonArray));
        _json.put("listDataObject", (Object)new JsonArray(listDataObject == null ? Collections.emptyList() : listDataObject.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listParams");
        _deliveryOptions.getHeaders().set("action", "listParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void setParams(Set<String> setString, Set<Byte> setByte, Set<Short> setShort, Set<Integer> setInt, Set<Long> setLong, Set<JsonObject> setJsonObject, Set<JsonArray> setJsonArray, Set<TestDataObject> setDataObject) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("setString", (Object)new JsonArray(new ArrayList<String>(setString)));
        _json.put("setByte", (Object)new JsonArray(new ArrayList<Byte>(setByte)));
        _json.put("setShort", (Object)new JsonArray(new ArrayList<Short>(setShort)));
        _json.put("setInt", (Object)new JsonArray(new ArrayList<Integer>(setInt)));
        _json.put("setLong", (Object)new JsonArray(new ArrayList<Long>(setLong)));
        _json.put("setJsonObject", (Object)new JsonArray(new ArrayList<JsonObject>(setJsonObject)));
        _json.put("setJsonArray", (Object)new JsonArray(new ArrayList<JsonArray>(setJsonArray)));
        _json.put("setDataObject", (Object)new JsonArray(setDataObject == null ? Collections.emptyList() : setDataObject.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setParams");
        _deliveryOptions.getHeaders().set("action", "setParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public void mapParams(Map<String, String> mapString, Map<String, Byte> mapByte, Map<String, Short> mapShort, Map<String, Integer> mapInt, Map<String, Long> mapLong, Map<String, JsonObject> mapJsonObject, Map<String, JsonArray> mapJsonArray) {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("mapString", (Object)new JsonObject(ProxyUtils.convertMap(mapString)));
        _json.put("mapByte", (Object)new JsonObject(ProxyUtils.convertMap(mapByte)));
        _json.put("mapShort", (Object)new JsonObject(ProxyUtils.convertMap(mapShort)));
        _json.put("mapInt", (Object)new JsonObject(ProxyUtils.convertMap(mapInt)));
        _json.put("mapLong", (Object)new JsonObject(ProxyUtils.convertMap(mapLong)));
        _json.put("mapJsonObject", (Object)new JsonObject(ProxyUtils.convertMap(mapJsonObject)));
        _json.put("mapJsonArray", (Object)new JsonObject(ProxyUtils.convertMap(mapJsonArray)));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapParams");
        _deliveryOptions.getHeaders().set("action", "mapParams");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }

    @Override
    public Future<String> stringHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "stringHandler");
        _deliveryOptions.getHeaders().set("action", "stringHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (String)msg.body());
    }

    @Override
    public Future<String> stringNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "stringNullHandler");
        _deliveryOptions.getHeaders().set("action", "stringNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (String)msg.body());
    }

    @Override
    public Future<Byte> byteHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "byteHandler");
        _deliveryOptions.getHeaders().set("action", "byteHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Byte)msg.body());
    }

    @Override
    public Future<Byte> byteNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "byteNullHandler");
        _deliveryOptions.getHeaders().set("action", "byteNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Byte)msg.body());
    }

    @Override
    public Future<Short> shortHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "shortHandler");
        _deliveryOptions.getHeaders().set("action", "shortHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Short)msg.body());
    }

    @Override
    public Future<Short> shortNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "shortNullHandler");
        _deliveryOptions.getHeaders().set("action", "shortNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Short)msg.body());
    }

    @Override
    public Future<Integer> intHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "intHandler");
        _deliveryOptions.getHeaders().set("action", "intHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Integer)msg.body());
    }

    @Override
    public Future<Integer> intNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "intNullHandler");
        _deliveryOptions.getHeaders().set("action", "intNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Integer)msg.body());
    }

    @Override
    public Future<Long> longHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "longHandler");
        _deliveryOptions.getHeaders().set("action", "longHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Long)msg.body());
    }

    @Override
    public Future<Long> longNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "longNullHandler");
        _deliveryOptions.getHeaders().set("action", "longNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Long)msg.body());
    }

    @Override
    public Future<Float> floatHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "floatHandler");
        _deliveryOptions.getHeaders().set("action", "floatHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Float)msg.body());
    }

    @Override
    public Future<Float> floatNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "floatNullHandler");
        _deliveryOptions.getHeaders().set("action", "floatNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Float)msg.body());
    }

    @Override
    public Future<Double> doubleHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "doubleHandler");
        _deliveryOptions.getHeaders().set("action", "doubleHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Double)msg.body());
    }

    @Override
    public Future<Double> doubleNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "doubleNullHandler");
        _deliveryOptions.getHeaders().set("action", "doubleNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Double)msg.body());
    }

    @Override
    public Future<Character> charHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "charHandler");
        _deliveryOptions.getHeaders().set("action", "charHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Character)msg.body());
    }

    @Override
    public Future<Character> charNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "charNullHandler");
        _deliveryOptions.getHeaders().set("action", "charNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Character)msg.body());
    }

    @Override
    public Future<Boolean> booleanHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "booleanHandler");
        _deliveryOptions.getHeaders().set("action", "booleanHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Boolean)msg.body());
    }

    @Override
    public Future<Boolean> booleanNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "booleanNullHandler");
        _deliveryOptions.getHeaders().set("action", "booleanNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Boolean)msg.body());
    }

    @Override
    public Future<JsonObject> jsonObjectHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonObjectHandler");
        _deliveryOptions.getHeaders().set("action", "jsonObjectHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonObject)msg.body());
    }

    @Override
    public Future<JsonObject> jsonObjectNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonObjectNullHandler");
        _deliveryOptions.getHeaders().set("action", "jsonObjectNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonObject)msg.body());
    }

    @Override
    public Future<JsonArray> jsonArrayHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonArrayHandler");
        _deliveryOptions.getHeaders().set("action", "jsonArrayHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonArray)msg.body());
    }

    @Override
    public Future<JsonArray> jsonArrayNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "jsonArrayNullHandler");
        _deliveryOptions.getHeaders().set("action", "jsonArrayNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonArray)msg.body());
    }

    @Override
    public Future<TestDataObject> dataObjectHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectHandler");
        _deliveryOptions.getHeaders().set("action", "dataObjectHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? new TestDataObject((JsonObject)msg.body()) : null);
    }

    @Override
    public Future<TestDataObject> dataObjectNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dataObjectNullHandler");
        _deliveryOptions.getHeaders().set("action", "dataObjectNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? new TestDataObject((JsonObject)msg.body()) : null);
    }

    @Override
    public Future<Void> voidHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "voidHandler");
        _deliveryOptions.getHeaders().set("action", "voidHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Void)msg.body());
    }

    @Override
    public Future<JsonObject> failingMethod() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "failingMethod");
        _deliveryOptions.getHeaders().set("action", "failingMethod");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonObject)msg.body());
    }

    @Override
    public Future<String> invokeWithMessage(JsonObject object, String str, int i, char chr, SomeEnum senum) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("object", (Object)object);
        _json.put("str", (Object)str);
        _json.put("i", (Object)i);
        _json.put("chr", (Object)chr);
        _json.put("senum", (Object)(senum == null ? null : senum.name()));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "invokeWithMessage");
        _deliveryOptions.getHeaders().set("action", "invokeWithMessage");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (String)msg.body());
    }

    @Override
    public Future<List<String>> listStringHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listStringHandler");
        _deliveryOptions.getHeaders().set("action", "listStringHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Byte>> listByteHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listByteHandler");
        _deliveryOptions.getHeaders().set("action", "listByteHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Short>> listShortHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listShortHandler");
        _deliveryOptions.getHeaders().set("action", "listShortHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Integer>> listIntHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listIntHandler");
        _deliveryOptions.getHeaders().set("action", "listIntHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Long>> listLongHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listLongHandler");
        _deliveryOptions.getHeaders().set("action", "listLongHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Float>> listFloatHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listFloatHandler");
        _deliveryOptions.getHeaders().set("action", "listFloatHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Double>> listDoubleHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listDoubleHandler");
        _deliveryOptions.getHeaders().set("action", "listDoubleHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<Character>> listCharHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listCharHandler");
        _deliveryOptions.getHeaders().set("action", "listCharHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertToListChar((JsonArray)((JsonArray)msg.body())));
    }

    @Override
    public Future<List<Boolean>> listBoolHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listBoolHandler");
        _deliveryOptions.getHeaders().set("action", "listBoolHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<JsonObject>> listJsonObjectHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listJsonObjectHandler");
        _deliveryOptions.getHeaders().set("action", "listJsonObjectHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<JsonArray>> listJsonArrayHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listJsonArrayHandler");
        _deliveryOptions.getHeaders().set("action", "listJsonArrayHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertList((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<List<TestDataObject>> listDataObjectHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listDataObjectHandler");
        _deliveryOptions.getHeaders().set("action", "listDataObjectHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
    }

    @Override
    public Future<Set<String>> setStringHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setStringHandler");
        _deliveryOptions.getHeaders().set("action", "setStringHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Byte>> setByteHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setByteHandler");
        _deliveryOptions.getHeaders().set("action", "setByteHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Short>> setShortHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setShortHandler");
        _deliveryOptions.getHeaders().set("action", "setShortHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Integer>> setIntHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setIntHandler");
        _deliveryOptions.getHeaders().set("action", "setIntHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Long>> setLongHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setLongHandler");
        _deliveryOptions.getHeaders().set("action", "setLongHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Float>> setFloatHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setFloatHandler");
        _deliveryOptions.getHeaders().set("action", "setFloatHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Double>> setDoubleHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setDoubleHandler");
        _deliveryOptions.getHeaders().set("action", "setDoubleHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Set<Character>> setCharHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setCharHandler");
        _deliveryOptions.getHeaders().set("action", "setCharHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertToSetChar((JsonArray)((JsonArray)msg.body())));
    }

    @Override
    public Future<Set<Boolean>> setBoolHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setBoolHandler");
        _deliveryOptions.getHeaders().set("action", "setBoolHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Map<String, String>> mapStringHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapStringHandler");
        _deliveryOptions.getHeaders().set("action", "mapStringHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertMap((Map)((JsonObject)msg.body()).getMap()));
    }

    @Override
    public Future<Map<String, Byte>> mapByteHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapByteHandler");
        _deliveryOptions.getHeaders().set("action", "mapByteHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertMap((Map)((JsonObject)msg.body()).getMap()));
    }

    @Override
    public Future<Map<String, Short>> mapShortHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapShortHandler");
        _deliveryOptions.getHeaders().set("action", "mapShortHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertMap((Map)((JsonObject)msg.body()).getMap()));
    }

    @Override
    public Future<Map<String, Integer>> mapIntHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapIntHandler");
        _deliveryOptions.getHeaders().set("action", "mapIntHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertMap((Map)((JsonObject)msg.body()).getMap()));
    }

    @Override
    public Future<Map<String, Long>> mapLongHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapLongHandler");
        _deliveryOptions.getHeaders().set("action", "mapLongHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertMap((Map)((JsonObject)msg.body()).getMap()));
    }

    @Override
    public Future<Map<String, Float>> mapFloatHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapFloatHandler");
        _deliveryOptions.getHeaders().set("action", "mapFloatHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertMap((Map)((JsonObject)msg.body()).getMap()));
    }

    @Override
    public Future<Map<String, Double>> mapDoubleHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapDoubleHandler");
        _deliveryOptions.getHeaders().set("action", "mapDoubleHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertMap((Map)((JsonObject)msg.body()).getMap()));
    }

    @Override
    public Future<Map<String, Character>> mapCharHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapCharHandler");
        _deliveryOptions.getHeaders().set("action", "mapCharHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertToMapChar((JsonObject)((JsonObject)msg.body())));
    }

    @Override
    public Future<Map<String, Boolean>> mapBoolHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapBoolHandler");
        _deliveryOptions.getHeaders().set("action", "mapBoolHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertMap((Map)((JsonObject)msg.body()).getMap()));
    }

    @Override
    public Future<Set<JsonObject>> setJsonObjectHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setJsonObjectHandler");
        _deliveryOptions.getHeaders().set("action", "setJsonObjectHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Map<String, JsonObject>> mapJsonObjectHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapJsonObjectHandler");
        _deliveryOptions.getHeaders().set("action", "mapJsonObjectHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertMap((Map)((JsonObject)msg.body()).getMap()));
    }

    @Override
    public Future<Set<JsonArray>> setJsonArrayHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setJsonArrayHandler");
        _deliveryOptions.getHeaders().set("action", "setJsonArrayHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertSet((List)((JsonArray)msg.body()).getList()));
    }

    @Override
    public Future<Map<String, JsonArray>> mapJsonArrayHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapJsonArrayHandler");
        _deliveryOptions.getHeaders().set("action", "mapJsonArrayHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ProxyUtils.convertMap((Map)((JsonObject)msg.body()).getMap()));
    }

    @Override
    public Future<Set<TestDataObject>> setDataObjectHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setDataObjectHandler");
        _deliveryOptions.getHeaders().set("action", "setDataObjectHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toSet()));
    }

    @Override
    public Future<Map<String, TestDataObject>> mapDataObject() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapDataObject");
        _deliveryOptions.getHeaders().set("action", "mapDataObject");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonObject)msg.body()).stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? new TestDataObject((JsonObject)e.getValue()) : null)));
    }

    @Override
    public Future<JsonObject> failingCall(String value) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("value", (Object)value);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "failingCall");
        _deliveryOptions.getHeaders().set("action", "failingCall");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (JsonObject)msg.body());
    }

    @Override
    public Future<List<TestDataObject>> listDataObjectContainingNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listDataObjectContainingNullHandler");
        _deliveryOptions.getHeaders().set("action", "listDataObjectContainingNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
    }

    @Override
    public Future<Set<TestDataObject>> setDataObjectContainingNullHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setDataObjectContainingNullHandler");
        _deliveryOptions.getHeaders().set("action", "setDataObjectContainingNullHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toSet()));
    }

    @Override
    public Future<ZonedDateTime> zonedDateTimeHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "zonedDateTimeHandler");
        _deliveryOptions.getHeaders().set("action", "zonedDateTimeHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? Mappers.deserializeZonedDateTime((String)msg.body()) : null);
    }

    @Override
    public Future<List<ZonedDateTime>> listZonedDateTimeHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "listZonedDateTimeHandler");
        _deliveryOptions.getHeaders().set("action", "listZonedDateTimeHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? Mappers.deserializeZonedDateTime((String)v) : null).collect(Collectors.toList()));
    }

    @Override
    public Future<Set<ZonedDateTime>> setZonedDateTimeHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setZonedDateTimeHandler");
        _deliveryOptions.getHeaders().set("action", "setZonedDateTimeHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? Mappers.deserializeZonedDateTime((String)v) : null).collect(Collectors.toSet()));
    }

    @Override
    public Future<Map<String, ZonedDateTime>> mapZonedDateTimeHandler() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "mapZonedDateTimeHandler");
        _deliveryOptions.getHeaders().set("action", "mapZonedDateTimeHandler");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonObject)msg.body()).stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? Mappers.deserializeZonedDateTime((String)e.getValue()) : null)));
    }

    @Override
    public void ignoredMethod() {
    }
}

