/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests.testmodel;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.HelperUtils;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceBinder;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.tests.testmodel.Mappers;
import io.vertx.serviceproxy.tests.testmodel.SomeEnum;
import io.vertx.serviceproxy.tests.testmodel.SomeEnumWithCustomConstructor;
import io.vertx.serviceproxy.tests.testmodel.TestConnection;
import io.vertx.serviceproxy.tests.testmodel.TestDataObject;
import io.vertx.serviceproxy.tests.testmodel.TestService;
import io.vertx.serviceproxy.tests.testmodel.sub.TestSubConnection;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class TestServiceVertxProxyHandler
extends ProxyHandler {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;
    private final Vertx vertx;
    private final TestService service;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;
    private final boolean includeDebugInfo;

    public TestServiceVertxProxyHandler(Vertx vertx, TestService service) {
        this(vertx, service, 300L);
    }

    public TestServiceVertxProxyHandler(Vertx vertx, TestService service, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond);
    }

    public TestServiceVertxProxyHandler(Vertx vertx, TestService service, boolean topLevel, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond, false);
    }

    public TestServiceVertxProxyHandler(Vertx vertx, TestService service, boolean topLevel, long timeoutSeconds, boolean includeDebugInfo) {
        this.vertx = vertx;
        this.service = service;
        this.includeDebugInfo = includeDebugInfo;
        this.timeoutSeconds = timeoutSeconds;
        try {
            this.vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        try {
            JsonObject json = (JsonObject)msg.body();
            String action = msg.headers().get("action");
            if (action == null) {
                throw new IllegalStateException("action not specified");
            }
            this.accessed();
            switch (action) {
                case "longDeliverySuccess": {
                    this.service.longDeliverySuccess().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "longDeliveryFailed": {
                    this.service.longDeliveryFailed().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "createConnection": {
                    this.service.createConnection((String)json.getValue("str")).onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            String proxyAddress = UUID.randomUUID().toString();
                            new ServiceBinder(this.vertx).setAddress(proxyAddress).setTopLevel(false).setTimeoutSeconds(this.timeoutSeconds).register(TestConnection.class, (Object)((TestConnection)res.result()));
                            msg.reply(null, new DeliveryOptions().addHeader("proxyaddr", proxyAddress));
                        }
                    });
                    break;
                }
                case "createSubConnection": {
                    this.service.createSubConnection((String)json.getValue("str")).onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            String proxyAddress = UUID.randomUUID().toString();
                            new ServiceBinder(this.vertx).setAddress(proxyAddress).setTopLevel(false).setTimeoutSeconds(this.timeoutSeconds).register(TestSubConnection.class, (Object)((TestSubConnection)res.result()));
                            msg.reply(null, new DeliveryOptions().addHeader("proxyaddr", proxyAddress));
                        }
                    });
                    break;
                }
                case "noParams": {
                    this.service.noParams();
                    break;
                }
                case "basicTypes": {
                    this.service.basicTypes((String)json.getValue("str"), json.getValue("b") == null ? null : Byte.valueOf(json.getLong("b").byteValue()), json.getValue("s") == null ? null : Short.valueOf(json.getLong("s").shortValue()), json.getValue("i") == null ? null : Integer.valueOf(json.getLong("i").intValue()), json.getValue("l") == null ? null : Long.valueOf(json.getLong("l")), (json.getValue("f") == null ? null : Float.valueOf(json.getDouble("f").floatValue())).floatValue(), json.getValue("d") == null ? null : Double.valueOf(json.getDouble("d")), (json.getInteger("c") == null ? null : Character.valueOf((char)json.getInteger("c").intValue())).charValue(), (Boolean)json.getValue("bool"));
                    break;
                }
                case "basicBoxedTypes": {
                    this.service.basicBoxedTypes((String)json.getValue("str"), json.getValue("b") == null ? null : Byte.valueOf(json.getLong("b").byteValue()), json.getValue("s") == null ? null : Short.valueOf(json.getLong("s").shortValue()), json.getValue("i") == null ? null : Integer.valueOf(json.getLong("i").intValue()), json.getValue("l") == null ? null : Long.valueOf(json.getLong("l")), json.getValue("f") == null ? null : Float.valueOf(json.getDouble("f").floatValue()), json.getValue("d") == null ? null : Double.valueOf(json.getDouble("d")), json.getInteger("c") == null ? null : Character.valueOf((char)json.getInteger("c").intValue()), (Boolean)json.getValue("bool"));
                    break;
                }
                case "basicBoxedTypesNull": {
                    this.service.basicBoxedTypesNull((String)json.getValue("str"), json.getValue("b") == null ? null : Byte.valueOf(json.getLong("b").byteValue()), json.getValue("s") == null ? null : Short.valueOf(json.getLong("s").shortValue()), json.getValue("i") == null ? null : Integer.valueOf(json.getLong("i").intValue()), json.getValue("l") == null ? null : Long.valueOf(json.getLong("l")), json.getValue("f") == null ? null : Float.valueOf(json.getDouble("f").floatValue()), json.getValue("d") == null ? null : Double.valueOf(json.getDouble("d")), json.getInteger("c") == null ? null : Character.valueOf((char)json.getInteger("c").intValue()), (Boolean)json.getValue("bool"));
                    break;
                }
                case "jsonTypes": {
                    this.service.jsonTypes((JsonObject)json.getValue("jsonObject"), (JsonArray)json.getValue("jsonArray"));
                    break;
                }
                case "jsonTypesNull": {
                    this.service.jsonTypesNull((JsonObject)json.getValue("jsonObject"), (JsonArray)json.getValue("jsonArray"));
                    break;
                }
                case "enumType": {
                    this.service.enumType(json.getString("someEnum") == null ? null : SomeEnum.valueOf(json.getString("someEnum")));
                    break;
                }
                case "enumTypeNull": {
                    this.service.enumTypeNull(json.getString("someEnum") == null ? null : SomeEnum.valueOf(json.getString("someEnum")));
                    break;
                }
                case "enumTypeAsResult": {
                    this.service.enumTypeAsResult().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "enumTypeAsResultNull": {
                    this.service.enumTypeAsResultNull().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "enumCustomType": {
                    this.service.enumCustomType(json.getString("someEnum") != null ? Mappers.deserializeSomeEnumWithCustomConstructor(json.getString("someEnum")) : null);
                    break;
                }
                case "enumCustomTypeNull": {
                    this.service.enumCustomTypeNull(json.getString("someEnum") != null ? Mappers.deserializeSomeEnumWithCustomConstructor(json.getString("someEnum")) : null);
                    break;
                }
                case "enumCustomTypeAsResult": {
                    this.service.enumCustomTypeAsResult().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply(res.result() != null ? Mappers.serializeSomeEnumWithCustomConstructor((SomeEnumWithCustomConstructor)((Object)((Object)res.result()))) : null);
                        }
                    });
                    break;
                }
                case "enumCustomTypeAsResultNull": {
                    this.service.enumCustomTypeAsResultNull().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply(res.result() != null ? Mappers.serializeSomeEnumWithCustomConstructor((SomeEnumWithCustomConstructor)((Object)((Object)res.result()))) : null);
                        }
                    });
                    break;
                }
                case "dataObjectType": {
                    this.service.dataObjectType(json.getJsonObject("options") != null ? new TestDataObject(json.getJsonObject("options")) : null);
                    break;
                }
                case "listdataObjectType": {
                    this.service.listdataObjectType(json.getJsonArray("list").stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
                    break;
                }
                case "setdataObjectType": {
                    this.service.setdataObjectType(json.getJsonArray("set").stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toSet()));
                    break;
                }
                case "dataObjectTypeNull": {
                    this.service.dataObjectTypeNull(json.getJsonObject("options") != null ? new TestDataObject(json.getJsonObject("options")) : null);
                    break;
                }
                case "dateTimeType": {
                    this.service.dateTimeType(json.getValue("dateTime") != null ? Mappers.deserializeZonedDateTime((String)json.getValue("dateTime")) : null);
                    break;
                }
                case "listDateTimeType": {
                    this.service.listDateTimeType(json.getJsonArray("list").stream().map(v -> v != null ? Mappers.deserializeZonedDateTime((String)v) : null).collect(Collectors.toList()));
                    break;
                }
                case "setDateTimeType": {
                    this.service.setDateTimeType(json.getJsonArray("set").stream().map(v -> v != null ? Mappers.deserializeZonedDateTime((String)v) : null).collect(Collectors.toSet()));
                    break;
                }
                case "mapDateTimeType": {
                    this.service.mapDateTimeType(json.getJsonObject("map").stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? Mappers.deserializeZonedDateTime((String)e.getValue()) : null)));
                    break;
                }
                case "listdataObjectTypeHavingNullValues": {
                    this.service.listdataObjectTypeHavingNullValues(json.getJsonArray("list").stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
                    break;
                }
                case "setdataObjectTypeHavingNullValues": {
                    this.service.setdataObjectTypeHavingNullValues(json.getJsonArray("set").stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toSet()));
                    break;
                }
                case "listdataObjectTypeNull": {
                    this.service.listdataObjectTypeNull(json.getJsonArray("list").stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
                    break;
                }
                case "setdataObjectTypeNull": {
                    this.service.setdataObjectTypeNull(json.getJsonArray("set").stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toSet()));
                    break;
                }
                case "mapDataObjectType": {
                    this.service.mapDataObjectType(json.getJsonObject("map").stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? new TestDataObject((JsonObject)e.getValue()) : null)));
                    break;
                }
                case "listParams": {
                    this.service.listParams(HelperUtils.convertList((List)json.getJsonArray("listString").getList()), json.getJsonArray("listByte").stream().map(o -> ((Number)o).byteValue()).collect(Collectors.toList()), json.getJsonArray("listShort").stream().map(o -> ((Number)o).shortValue()).collect(Collectors.toList()), json.getJsonArray("listInt").stream().map(o -> ((Number)o).intValue()).collect(Collectors.toList()), json.getJsonArray("listLong").stream().map(o -> ((Number)o).longValue()).collect(Collectors.toList()), HelperUtils.convertList((List)json.getJsonArray("listJsonObject").getList()), HelperUtils.convertList((List)json.getJsonArray("listJsonArray").getList()), json.getJsonArray("listDataObject").stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toList()));
                    break;
                }
                case "setParams": {
                    this.service.setParams(HelperUtils.convertSet((List)json.getJsonArray("setString").getList()), json.getJsonArray("setByte").stream().map(o -> ((Number)o).byteValue()).collect(Collectors.toSet()), json.getJsonArray("setShort").stream().map(o -> ((Number)o).shortValue()).collect(Collectors.toSet()), json.getJsonArray("setInt").stream().map(o -> ((Number)o).intValue()).collect(Collectors.toSet()), json.getJsonArray("setLong").stream().map(o -> ((Number)o).longValue()).collect(Collectors.toSet()), HelperUtils.convertSet((List)json.getJsonArray("setJsonObject").getList()), HelperUtils.convertSet((List)json.getJsonArray("setJsonArray").getList()), json.getJsonArray("setDataObject").stream().map(v -> v != null ? new TestDataObject((JsonObject)v) : null).collect(Collectors.toSet()));
                    break;
                }
                case "mapParams": {
                    this.service.mapParams(HelperUtils.convertMap((Map)json.getJsonObject("mapString").getMap()), json.getJsonObject("mapByte").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Number)entry.getValue()).byteValue())), json.getJsonObject("mapShort").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Number)entry.getValue()).shortValue())), json.getJsonObject("mapInt").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Number)entry.getValue()).intValue())), json.getJsonObject("mapLong").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Number)entry.getValue()).longValue())), HelperUtils.convertMap((Map)json.getJsonObject("mapJsonObject").getMap()), HelperUtils.convertMap((Map)json.getJsonObject("mapJsonArray").getMap()));
                    break;
                }
                case "stringHandler": {
                    this.service.stringHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "stringNullHandler": {
                    this.service.stringNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "byteHandler": {
                    this.service.byteHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "byteNullHandler": {
                    this.service.byteNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "shortHandler": {
                    this.service.shortHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "shortNullHandler": {
                    this.service.shortNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "intHandler": {
                    this.service.intHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "intNullHandler": {
                    this.service.intNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "longHandler": {
                    this.service.longHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "longNullHandler": {
                    this.service.longNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "floatHandler": {
                    this.service.floatHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "floatNullHandler": {
                    this.service.floatNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "doubleHandler": {
                    this.service.doubleHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "doubleNullHandler": {
                    this.service.doubleNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "charHandler": {
                    this.service.charHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "charNullHandler": {
                    this.service.charNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "booleanHandler": {
                    this.service.booleanHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "booleanNullHandler": {
                    this.service.booleanNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "jsonObjectHandler": {
                    this.service.jsonObjectHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "jsonObjectNullHandler": {
                    this.service.jsonObjectNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "jsonArrayHandler": {
                    this.service.jsonArrayHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "jsonArrayNullHandler": {
                    this.service.jsonArrayNullHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "dataObjectHandler": {
                    this.service.dataObjectHandler().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply(res.result() != null ? ((TestDataObject)res.result()).toJson() : null);
                        }
                    });
                    break;
                }
                case "dataObjectNullHandler": {
                    this.service.dataObjectNullHandler().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply(res.result() != null ? ((TestDataObject)res.result()).toJson() : null);
                        }
                    });
                    break;
                }
                case "voidHandler": {
                    this.service.voidHandler().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "failingMethod": {
                    this.service.failingMethod().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "invokeWithMessage": {
                    this.service.invokeWithMessage((JsonObject)json.getValue("object"), (String)json.getValue("str"), json.getValue("i") == null ? null : Integer.valueOf(json.getLong("i").intValue()), (json.getInteger("chr") == null ? null : Character.valueOf((char)json.getInteger("chr").intValue())).charValue(), json.getString("senum") == null ? null : SomeEnum.valueOf(json.getString("senum"))).onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listStringHandler": {
                    this.service.listStringHandler().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listByteHandler": {
                    this.service.listByteHandler().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listShortHandler": {
                    this.service.listShortHandler().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listIntHandler": {
                    this.service.listIntHandler().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listLongHandler": {
                    this.service.listLongHandler().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listFloatHandler": {
                    this.service.listFloatHandler().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listDoubleHandler": {
                    this.service.listDoubleHandler().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listCharHandler": {
                    this.service.listCharHandler().onComplete(HelperUtils.createListCharHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listBoolHandler": {
                    this.service.listBoolHandler().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listJsonObjectHandler": {
                    this.service.listJsonObjectHandler().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listJsonArrayHandler": {
                    this.service.listJsonArrayHandler().onComplete(HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listDataObjectHandler": {
                    this.service.listDataObjectHandler().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "setStringHandler": {
                    this.service.setStringHandler().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setByteHandler": {
                    this.service.setByteHandler().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setShortHandler": {
                    this.service.setShortHandler().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setIntHandler": {
                    this.service.setIntHandler().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setLongHandler": {
                    this.service.setLongHandler().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setFloatHandler": {
                    this.service.setFloatHandler().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setDoubleHandler": {
                    this.service.setDoubleHandler().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setCharHandler": {
                    this.service.setCharHandler().onComplete(HelperUtils.createSetCharHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setBoolHandler": {
                    this.service.setBoolHandler().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapStringHandler": {
                    this.service.mapStringHandler().onComplete(HelperUtils.createMapHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapByteHandler": {
                    this.service.mapByteHandler().onComplete(HelperUtils.createMapHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapShortHandler": {
                    this.service.mapShortHandler().onComplete(HelperUtils.createMapHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapIntHandler": {
                    this.service.mapIntHandler().onComplete(HelperUtils.createMapHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapLongHandler": {
                    this.service.mapLongHandler().onComplete(HelperUtils.createMapHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapFloatHandler": {
                    this.service.mapFloatHandler().onComplete(HelperUtils.createMapHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapDoubleHandler": {
                    this.service.mapDoubleHandler().onComplete(HelperUtils.createMapHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapCharHandler": {
                    this.service.mapCharHandler().onComplete(HelperUtils.createMapCharHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapBoolHandler": {
                    this.service.mapBoolHandler().onComplete(HelperUtils.createMapHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setJsonObjectHandler": {
                    this.service.setJsonObjectHandler().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapJsonObjectHandler": {
                    this.service.mapJsonObjectHandler().onComplete(HelperUtils.createMapHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setJsonArrayHandler": {
                    this.service.setJsonArrayHandler().onComplete(HelperUtils.createSetHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "mapJsonArrayHandler": {
                    this.service.mapJsonArrayHandler().onComplete(HelperUtils.createMapHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "setDataObjectHandler": {
                    this.service.setDataObjectHandler().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply((Object)new JsonArray(((Set)res.result()).stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "mapDataObject": {
                    this.service.mapDataObject().onComplete(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply((Object)new JsonObject(((Map)res.result()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? ((TestDataObject)e.getValue()).toJson() : null))));
                        }
                    });
                    break;
                }
                case "failingCall": {
                    this.service.failingCall((String)json.getValue("value")).onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "listDataObjectContainingNullHandler": {
                    this.service.listDataObjectContainingNullHandler().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "setDataObjectContainingNullHandler": {
                    this.service.setDataObjectContainingNullHandler().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply((Object)new JsonArray(((Set)res.result()).stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "zonedDateTimeHandler": {
                    this.service.zonedDateTimeHandler().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply(res.result() != null ? Mappers.serializeZonedDateTime((ZonedDateTime)res.result()) : null);
                        }
                    });
                    break;
                }
                case "listZonedDateTimeHandler": {
                    this.service.listZonedDateTimeHandler().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(v -> v != null ? Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "setZonedDateTimeHandler": {
                    this.service.setZonedDateTimeHandler().onComplete(res -> {
                        if (res.failed()) {
                            HelperUtils.manageFailure((Message)msg, (Throwable)res.cause(), (boolean)this.includeDebugInfo);
                        } else {
                            msg.reply((Object)new JsonArray(((Set)res.result()).stream().map(v -> v != null ? Mappers.serializeZonedDateTime(v) : null).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "mapZonedDateTimeHandler": {
                    this.service.mapZonedDateTimeHandler().onComplete(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply((Object)new JsonObject(((Map)res.result()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() != null ? Mappers.serializeZonedDateTime((ZonedDateTime)e.getValue()) : null))));
                        }
                    });
                    break;
                }
                case "ignoredMethod": {
                    this.service.ignoredMethod();
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid action: " + action);
                }
            }
        }
        catch (Throwable t) {
            if (this.includeDebugInfo) {
                msg.reply((Object)new ServiceException(500, t.getMessage(), HelperUtils.generateDebugInfo((Throwable)t)));
            } else {
                msg.reply((Object)new ServiceException(500, t.getMessage()));
            }
            throw t;
        }
    }
}

