/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests.testmodel2;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.HelperUtils;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import io.vertx.serviceproxy.tests.testmodel2.FuturizedTestService;

public class FuturizedTestServiceVertxProxyHandler
extends ProxyHandler {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;
    private final Vertx vertx;
    private final FuturizedTestService service;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;
    private final boolean includeDebugInfo;

    public FuturizedTestServiceVertxProxyHandler(Vertx vertx, FuturizedTestService service) {
        this(vertx, service, 300L);
    }

    public FuturizedTestServiceVertxProxyHandler(Vertx vertx, FuturizedTestService service, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond);
    }

    public FuturizedTestServiceVertxProxyHandler(Vertx vertx, FuturizedTestService service, boolean topLevel, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond, false);
    }

    public FuturizedTestServiceVertxProxyHandler(Vertx vertx, FuturizedTestService service, boolean topLevel, long timeoutSeconds, boolean includeDebugInfo) {
        this.vertx = vertx;
        this.service = service;
        this.includeDebugInfo = includeDebugInfo;
        this.timeoutSeconds = timeoutSeconds;
        try {
            this.vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        try {
            JsonObject json = (JsonObject)msg.body();
            String action = msg.headers().get("action");
            if (action == null) {
                throw new IllegalStateException("action not specified");
            }
            this.accessed();
            switch (action) {
                case "ok": {
                    this.service.ok().onComplete(HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid action: " + action);
                }
            }
        }
        catch (Throwable t) {
            if (this.includeDebugInfo) {
                msg.reply((Object)new ServiceException(500, t.getMessage(), HelperUtils.generateDebugInfo((Throwable)t)));
            } else {
                msg.reply((Object)new ServiceException(500, t.getMessage()));
            }
            throw t;
        }
    }
}

