/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.tests.utils;

import io.vertx.core.Future;
import io.vertx.serviceproxy.AuthenticationInterceptor;
import io.vertx.serviceproxy.AuthorizationInterceptor;
import io.vertx.serviceproxy.ServiceInterceptor;
import io.vertx.serviceproxy.impl.InterceptorHolder;
import io.vertx.serviceproxy.impl.InterceptorPriority;
import io.vertx.serviceproxy.impl.utils.InterceptorUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class InterceptorUtilsTest {
    @Test
    public void testGetWeightAuthn() {
        AuthenticationInterceptor authn = AuthenticationInterceptor.create(null);
        Assert.assertEquals((Object)InterceptorPriority.AUTHENTICATION, (Object)InterceptorUtils.getWeight((ServiceInterceptor)authn));
    }

    @Test
    public void testGetWeightAuthz() {
        AuthorizationInterceptor authz = AuthorizationInterceptor.create(null);
        Assert.assertEquals((Object)InterceptorPriority.AUTHORIZATION, (Object)InterceptorUtils.getWeight((ServiceInterceptor)authz));
    }

    @Test
    public void testGetWeightUser() {
        ServiceInterceptor user = (vertx, context, msg) -> Future.succeededFuture();
        Assert.assertEquals((Object)InterceptorPriority.USER, (Object)InterceptorUtils.getWeight((ServiceInterceptor)user));
    }

    @Test
    public void testCheckInterceptorOrderFromEmptyList() {
        ArrayList interceptorHolders = new ArrayList();
        AuthenticationInterceptor authn = AuthenticationInterceptor.create(null);
        InterceptorUtils.checkInterceptorOrder(interceptorHolders, (ServiceInterceptor)authn);
        interceptorHolders.clear();
        AuthorizationInterceptor authz = AuthorizationInterceptor.create(null);
        InterceptorUtils.checkInterceptorOrder(interceptorHolders, (ServiceInterceptor)authz);
        interceptorHolders.clear();
        ServiceInterceptor user = (vertx, context, msg) -> Future.succeededFuture();
        InterceptorUtils.checkInterceptorOrder(interceptorHolders, (ServiceInterceptor)user);
    }

    @Test
    public void testCheckInterceptorOrderRightPriority() {
        ArrayList<InterceptorHolder> interceptorHolders = new ArrayList<InterceptorHolder>();
        AuthenticationInterceptor authn = AuthenticationInterceptor.create(null);
        InterceptorUtils.checkInterceptorOrder(interceptorHolders, (ServiceInterceptor)authn);
        interceptorHolders.add(new InterceptorHolder((ServiceInterceptor)authn));
        AuthorizationInterceptor authz = AuthorizationInterceptor.create(null);
        InterceptorUtils.checkInterceptorOrder(interceptorHolders, (ServiceInterceptor)authz);
        interceptorHolders.add(new InterceptorHolder((ServiceInterceptor)authz));
        ServiceInterceptor user = (vertx, context, msg) -> Future.succeededFuture();
        InterceptorUtils.checkInterceptorOrder(interceptorHolders, (ServiceInterceptor)user);
    }

    @Test
    public void testCheckInterceptorOrderWrongPriority() {
        ArrayList<InterceptorHolder> interceptorHolders = new ArrayList<InterceptorHolder>();
        AuthorizationInterceptor authz = AuthorizationInterceptor.create(null);
        interceptorHolders.add(new InterceptorHolder((ServiceInterceptor)authz));
        AuthenticationInterceptor authn = AuthenticationInterceptor.create(null);
        Assert.assertThrows(IllegalStateException.class, () -> InterceptorUtilsTest.lambda$testCheckInterceptorOrderWrongPriority$3(interceptorHolders, (ServiceInterceptor)authn));
        interceptorHolders.clear();
        ServiceInterceptor user = (vertx, context, msg) -> Future.succeededFuture();
        interceptorHolders.add(new InterceptorHolder(user));
        Assert.assertThrows(IllegalStateException.class, () -> InterceptorUtilsTest.lambda$testCheckInterceptorOrderWrongPriority$5(interceptorHolders, (ServiceInterceptor)authn));
        Assert.assertThrows(IllegalStateException.class, () -> InterceptorUtilsTest.lambda$testCheckInterceptorOrderWrongPriority$6(interceptorHolders, (ServiceInterceptor)authz));
    }

    private static /* synthetic */ void lambda$testCheckInterceptorOrderWrongPriority$6(List interceptorHolders, ServiceInterceptor authz) throws Throwable {
        InterceptorUtils.checkInterceptorOrder((List)interceptorHolders, (ServiceInterceptor)authz);
    }

    private static /* synthetic */ void lambda$testCheckInterceptorOrderWrongPriority$5(List interceptorHolders, ServiceInterceptor authn) throws Throwable {
        InterceptorUtils.checkInterceptorOrder((List)interceptorHolders, (ServiceInterceptor)authn);
    }

    private static /* synthetic */ void lambda$testCheckInterceptorOrderWrongPriority$3(List interceptorHolders, ServiceInterceptor authn) throws Throwable {
        InterceptorUtils.checkInterceptorOrder((List)interceptorHolders, (ServiceInterceptor)authn);
    }
}

