/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.shell.ShellServerOptions;
import io.vertx.ext.shell.ShellServiceOptionsConverter;
import io.vertx.ext.shell.term.HttpTermOptions;
import io.vertx.ext.shell.term.SSHTermOptions;
import io.vertx.ext.shell.term.TelnetTermOptions;
import java.util.Map;

@DataObject(generateConverter=true)
public class ShellServiceOptions
extends ShellServerOptions {
    private TelnetTermOptions telnetOptions;
    private SSHTermOptions sshOptions;
    private HttpTermOptions httpOptions;

    public ShellServiceOptions() {
    }

    public ShellServiceOptions(ShellServiceOptions that) {
        super(that);
        this.telnetOptions = that.telnetOptions != null ? new TelnetTermOptions(that.telnetOptions) : null;
        this.sshOptions = that.sshOptions != null ? new SSHTermOptions(that.sshOptions) : null;
        this.httpOptions = that.httpOptions != null ? new HttpTermOptions(that.httpOptions) : null;
    }

    public ShellServiceOptions(JsonObject json) {
        super(json);
        ShellServiceOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    @Override
    public ShellServiceOptions setWelcomeMessage(String welcomeMessage) {
        return (ShellServiceOptions)super.setWelcomeMessage(welcomeMessage);
    }

    @Override
    public ShellServiceOptions setSessionTimeout(long timeoutMillis) {
        return (ShellServiceOptions)super.setSessionTimeout(timeoutMillis);
    }

    @Override
    public ShellServiceOptions setReaperInterval(long reaperInterval) {
        return (ShellServiceOptions)super.setReaperInterval(reaperInterval);
    }

    public TelnetTermOptions getTelnetOptions() {
        return this.telnetOptions;
    }

    public ShellServiceOptions setTelnetOptions(TelnetTermOptions telnetOptions) {
        this.telnetOptions = telnetOptions;
        return this;
    }

    public SSHTermOptions getSSHOptions() {
        return this.sshOptions;
    }

    public ShellServiceOptions setSSHOptions(SSHTermOptions sshOptions) {
        this.sshOptions = sshOptions;
        return this;
    }

    public HttpTermOptions getHttpOptions() {
        return this.httpOptions;
    }

    public ShellServiceOptions setHttpOptions(HttpTermOptions httpOptions) {
        this.httpOptions = httpOptions;
        return this;
    }
}

