/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.termd.core.telnet.TelnetConnection;
import io.termd.core.telnet.TelnetHandler;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetSocket;
import java.util.concurrent.TimeUnit;

public class VertxTelnetConnection
extends TelnetConnection {
    final NetSocket socket;
    final Context context;

    public VertxTelnetConnection(TelnetHandler handler, Context context, NetSocket socket) {
        super(handler);
        this.context = context;
        this.socket = socket;
    }

    protected void execute(Runnable task) {
        this.context.runOnContext(event -> task.run());
    }

    protected void schedule(Runnable task, long delay, TimeUnit unit) {
        long millis = unit.toMillis(delay);
        this.context.owner().setTimer(millis, event -> task.run());
    }

    protected void send(byte[] data) {
        this.socket.write((Object)Buffer.buffer((byte[])data));
    }

    public void onClose() {
        super.onClose();
    }

    public void close() {
        this.socket.close();
    }
}

