/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameHelper;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TcpEventBusBridgeImpl
implements TcpEventBusBridge {
    private static final Logger log = LoggerFactory.getLogger(TcpEventBusBridgeImpl.class);
    private final EventBus eb;
    private final NetServer server;
    private final Map<String, Pattern> compiledREs = new HashMap<String, Pattern>();
    private final BridgeOptions options;

    public TcpEventBusBridgeImpl(Vertx vertx, BridgeOptions options, NetServerOptions netServerOptions) {
        this.eb = vertx.eventBus();
        this.options = options != null ? options : new BridgeOptions();
        this.server = vertx.createNetServer(netServerOptions == null ? new NetServerOptions() : netServerOptions);
        this.server.connectHandler(this::handler);
    }

    @Override
    public TcpEventBusBridge listen() {
        this.server.listen();
        return this;
    }

    @Override
    public TcpEventBusBridge listen(int port) {
        this.server.listen(port);
        return this;
    }

    @Override
    public TcpEventBusBridge listen(int port, String address) {
        this.server.listen(port, address);
        return this;
    }

    @Override
    public TcpEventBusBridge listen(Handler<AsyncResult<TcpEventBusBridge>> handler) {
        this.server.listen(res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)this));
            }
        });
        return this;
    }

    @Override
    public TcpEventBusBridge listen(int port, String address, Handler<AsyncResult<TcpEventBusBridge>> handler) {
        this.server.listen(port, address, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)this));
            }
        });
        return this;
    }

    @Override
    public TcpEventBusBridge listen(int port, Handler<AsyncResult<TcpEventBusBridge>> handler) {
        this.server.listen(port, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)this));
            }
        });
        return this;
    }

    private void handler(NetSocket socket) {
        ConcurrentHashMap registry = new ConcurrentHashMap();
        ConcurrentHashMap replies = new ConcurrentHashMap();
        FrameParser parser = new FrameParser((Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.failed()) {
                log.error((Object)res.cause());
                return;
            }
            JsonObject msg = (JsonObject)res.result();
            String address = msg.getString("address");
            JsonObject headers = msg.getJsonObject("headers");
            DeliveryOptions deliveryOptions = this.parseMsgHeaders(new DeliveryOptions(), headers);
            JsonObject body = msg.getJsonObject("body");
            String type = msg.getString("type", "message");
            if ("ping".equals(type)) {
                return;
            }
            if (address == null) {
                FrameHelper.sendErrFrame("address_required", (WriteStream<Buffer>)socket);
                return;
            }
            switch (type) {
                case "send": {
                    if (this.checkMatches(true, address)) {
                        String replyAddress = msg.getString("replyAddress");
                        if (replyAddress != null) {
                            this.eb.send(address, (Object)body, deliveryOptions, res1 -> {
                                if (res1.failed()) {
                                    FrameHelper.sendFrame("message", (ReplyException)res1.cause(), (WriteStream<Buffer>)socket);
                                } else {
                                    Message response = (Message)res1.result();
                                    JsonObject responseHeaders = new JsonObject();
                                    for (Map.Entry entry : response.headers()) {
                                        responseHeaders.put((String)entry.getKey(), (String)entry.getValue());
                                    }
                                    FrameHelper.sendFrame("message", replyAddress, response.replyAddress(), responseHeaders, (JsonObject)response.body(), (WriteStream<Buffer>)socket);
                                }
                            });
                            break;
                        }
                        if (replies.containsKey(address)) {
                            ((Message)replies.remove(address)).reply((Object)body, deliveryOptions);
                            break;
                        }
                        this.eb.send(address, (Object)body, deliveryOptions);
                        break;
                    }
                    FrameHelper.sendErrFrame("access_denied", (WriteStream<Buffer>)socket);
                    break;
                }
                case "publish": {
                    if (this.checkMatches(true, address)) {
                        this.eb.publish(address, (Object)body, deliveryOptions);
                        break;
                    }
                    FrameHelper.sendErrFrame("access_denied", (WriteStream<Buffer>)socket);
                    break;
                }
                case "register": {
                    if (this.checkMatches(false, address)) {
                        registry.put(address, this.eb.consumer(address, res1 -> {
                            if (res1.replyAddress() != null) {
                                replies.put(res1.replyAddress(), res1);
                            }
                            JsonObject responseHeaders = new JsonObject();
                            for (Map.Entry entry : res1.headers()) {
                                responseHeaders.put((String)entry.getKey(), (String)entry.getValue());
                            }
                            FrameHelper.sendFrame("message", res1.address(), res1.replyAddress(), responseHeaders, (JsonObject)res1.body(), (WriteStream<Buffer>)socket);
                        }));
                        break;
                    }
                    FrameHelper.sendErrFrame("access_denied", (WriteStream<Buffer>)socket);
                    break;
                }
                case "unregister": {
                    if (this.checkMatches(false, address)) {
                        MessageConsumer consumer = (MessageConsumer)registry.remove(address);
                        if (consumer != null) {
                            consumer.unregister();
                            break;
                        }
                        FrameHelper.sendErrFrame("unknown_address", (WriteStream<Buffer>)socket);
                        break;
                    }
                    FrameHelper.sendErrFrame("access_denied", (WriteStream<Buffer>)socket);
                    break;
                }
                default: {
                    FrameHelper.sendErrFrame("unknown_type", (WriteStream<Buffer>)socket);
                }
            }
        }));
        socket.handler((Handler)parser);
        socket.exceptionHandler(t -> {
            registry.values().forEach(MessageConsumer::unregister);
            registry.clear();
            socket.close();
        });
        socket.endHandler(v -> {
            registry.values().forEach(MessageConsumer::unregister);
            registry.clear();
        });
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.server.close(handler);
    }

    @Override
    public void close() {
        this.server.close();
    }

    private boolean checkMatches(boolean inbound, String address) {
        List matches = inbound ? this.options.getInboundPermitteds() : this.options.getOutboundPermitteds();
        for (PermittedOptions matchHolder : matches) {
            String matchAddress = matchHolder.getAddress();
            String matchRegex = matchAddress == null ? matchHolder.getAddressRegex() : null;
            boolean addressOK = matchAddress == null ? matchRegex == null || this.regexMatches(matchRegex, address) : matchAddress.equals(address);
            if (!addressOK) continue;
            return true;
        }
        return false;
    }

    private boolean regexMatches(String matchRegex, String address) {
        Pattern pattern = this.compiledREs.get(matchRegex);
        if (pattern == null) {
            pattern = Pattern.compile(matchRegex);
            this.compiledREs.put(matchRegex, pattern);
        }
        Matcher m = pattern.matcher(address);
        return m.matches();
    }

    private DeliveryOptions parseMsgHeaders(DeliveryOptions options, JsonObject headers) {
        if (headers == null) {
            return options;
        }
        for (String fname : headers.fieldNames()) {
            options.addHeader(fname, headers.getString(fname));
        }
        return options;
    }
}

