/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp.impl.protocol;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.WriteStream;

public class FrameHelper {
    private FrameHelper() {
    }

    public static void sendFrame(String type, String address, String replyAddress, JsonObject headers, JsonObject body, WriteStream<Buffer> handler) {
        JsonObject payload = new JsonObject().put("type", type);
        if (address != null) {
            payload.put("address", address);
        }
        if (replyAddress != null) {
            payload.put("replyAddress", replyAddress);
        }
        if (headers != null) {
            payload.put("headers", headers);
        }
        if (body != null) {
            payload.put("body", body);
        }
        byte[] data = payload.encode().getBytes();
        handler.write((Object)Buffer.buffer().appendInt(data.length).appendBytes(data));
    }

    public static void sendFrame(String type, String address, String replyAddress, JsonObject body, WriteStream<Buffer> handler) {
        FrameHelper.sendFrame(type, address, replyAddress, null, body, handler);
    }

    public static void sendFrame(String type, String address, JsonObject body, WriteStream<Buffer> handler) {
        FrameHelper.sendFrame(type, address, null, null, body, handler);
    }

    public static void sendFrame(String type, WriteStream<Buffer> handler) {
        FrameHelper.sendFrame(type, null, null, null, null, handler);
    }

    public static void sendFrame(String type, ReplyException failure, WriteStream<Buffer> handler) {
        JsonObject payload = new JsonObject().put("type", type).put("failureCode", Integer.valueOf(failure.failureCode())).put("failureType", failure.failureType().name()).put("message", failure.getMessage());
        byte[] data = payload.encode().getBytes();
        handler.write((Object)Buffer.buffer().appendInt(data.length).appendBytes(data));
    }

    public static void sendErrFrame(String message, WriteStream<Buffer> handler) {
        JsonObject payload = new JsonObject().put("type", "err").put("message", message);
        byte[] data = payload.encode().getBytes();
        handler.write((Object)Buffer.buffer().appendInt(data.length).appendBytes(data));
    }
}

