/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp.impl.protocol;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;

public class FrameParser
implements Handler<Buffer> {
    private Buffer _buffer;
    private int _offset;
    private final Handler<AsyncResult<JsonObject>> client;

    public FrameParser(Handler<AsyncResult<JsonObject>> client) {
        this.client = client;
    }

    public void handle(Buffer buffer) {
        block3: {
            int offset;
            this.append(buffer);
            while (true) {
                offset = this._offset;
                int remainingBytes = this.bytesRemaining();
                if (remainingBytes < 4) break block3;
                int length = this._buffer.getInt(this._offset);
                this._offset += 4;
                if (remainingBytes - 4 < length) break;
                try {
                    this.client.handle((Object)Future.succeededFuture((Object)new JsonObject(this._buffer.getString(this._offset, this._offset + length))));
                }
                catch (DecodeException e) {
                    this.client.handle((Object)Future.failedFuture((Throwable)e));
                }
                this._offset += length;
            }
            this._offset = offset;
        }
    }

    private void append(Buffer newBuffer) {
        if (newBuffer == null) {
            return;
        }
        if (this._buffer == null) {
            this._buffer = newBuffer;
            return;
        }
        if (this._offset >= this._buffer.length()) {
            this._buffer = newBuffer;
            this._offset = 0;
            return;
        }
        if (this._offset > 0) {
            this._buffer = this._buffer.getBuffer(this._offset, this._buffer.length());
        }
        this._buffer.appendBuffer(newBuffer);
        this._offset = 0;
    }

    private int bytesRemaining() {
        return this._buffer.length() - this._offset < 0 ? 0 : this._buffer.length() - this._offset;
    }
}

