/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import io.vertx.redis.impl.RedisCommand;
import io.vertx.redis.impl.ResponseTransform;
import java.nio.charset.Charset;
import java.util.List;

public class Command<T> {
    private static final byte ARGS_PREFIX = 42;
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final byte BYTES_PREFIX = 36;
    private static final byte[] NEG_ONE = Command.convert(-1L);
    private static final int NUM_MAP_LENGTH = 256;
    private static final byte[][] numMap = new byte[256][];
    private final Context context;
    private final Buffer buffer;
    private final ResponseTransform transform;
    private final String encoding;
    private final Class<T> returnType;
    private int expectedReplies = 1;
    private Handler<AsyncResult<T>> handler;

    private static byte[] numToBytes(long value) {
        if (value >= 0L && value < 256L) {
            int index = (int)value;
            return numMap[index];
        }
        if (value == -1L) {
            return NEG_ONE;
        }
        return Command.convert(value);
    }

    private static byte[] convert(long value) {
        boolean negative = value < 0L;
        long abs = Math.abs(value);
        int index = (value == 0L ? 0 : (int)Math.log10(abs)) + (negative ? 2 : 1);
        byte[] bytes = new byte[index];
        if (negative) {
            bytes[0] = 45;
        }
        long next = abs;
        while ((next /= 10L) > 0L) {
            bytes[--index] = (byte)(48L + abs % 10L);
            abs = next;
        }
        bytes[--index] = (byte)(48L + abs);
        return bytes;
    }

    public Command(Context context, RedisCommand command, List<?> args, Charset encoding, ResponseTransform transform, Class<T> returnType) {
        this.context = context;
        this.encoding = encoding.name();
        this.transform = transform;
        this.returnType = returnType;
        int totalArgs = args == null ? 0 : args.size();
        String[] commandTokens = command.getTokens();
        this.buffer = Buffer.buffer();
        this.buffer.appendByte((byte)42);
        this.buffer.appendBytes(Command.numToBytes(totalArgs + commandTokens.length));
        this.buffer.appendBytes(CRLF);
        for (String token : commandTokens) {
            this.appendToBuffer(token.getBytes(encoding), encoding, this.buffer);
        }
        for (int i = 0; i < totalArgs; ++i) {
            this.appendToBuffer(args.get(i), encoding, this.buffer);
        }
    }

    public Command<T> setExpectedReplies(int expectedReplies) {
        this.expectedReplies = expectedReplies;
        return this;
    }

    public Command<T> handler(Handler<AsyncResult<T>> handler) {
        this.handler = handler;
        return this;
    }

    public int getExpectedReplies() {
        return this.expectedReplies;
    }

    public ResponseTransform responseTransform() {
        return this.transform;
    }

    public String encoding() {
        return this.encoding;
    }

    public Class<T> returnType() {
        return this.returnType;
    }

    public void handle(AsyncResult<T> asyncResult) {
        if (this.handler != null) {
            if (this.context != null) {
                if (Vertx.currentContext() == this.context) {
                    this.handler.handle(asyncResult);
                } else {
                    this.context.runOnContext(v -> this.handler.handle((Object)asyncResult));
                }
            } else {
                this.handler.handle(asyncResult);
            }
        }
    }

    public void writeTo(WriteStream<Buffer> writeStream) {
        writeStream.write((Object)this.buffer);
    }

    private void appendToBuffer(Object value, Charset encoding, Buffer buffer) {
        buffer.appendByte((byte)36);
        if (value == null) {
            buffer.appendByte((byte)48);
            buffer.appendBytes(CRLF);
            buffer.appendBytes(CRLF);
        } else {
            byte[] bytes = value instanceof byte[] ? (byte[])value : (value instanceof Buffer ? ((Buffer)value).getBytes() : (value instanceof String ? ((String)value).getBytes(encoding) : (value instanceof Byte ? Command.numToBytes(((Byte)value).byteValue()) : (value instanceof Short ? Command.numToBytes(((Short)value).shortValue()) : (value instanceof Integer ? Command.numToBytes(((Integer)value).intValue()) : (value instanceof Long ? Command.numToBytes((Long)value) : value.toString().getBytes(encoding)))))));
            buffer.appendBytes(Command.numToBytes(bytes.length));
            buffer.appendBytes(CRLF);
            buffer.appendBytes(bytes);
            buffer.appendBytes(CRLF);
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Command.numMap[i] = Command.convert(i);
        }
    }
}

