/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.WriteStream;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.impl.Command;
import io.vertx.redis.impl.RedisCommand;
import io.vertx.redis.impl.RedisSubscriptions;
import io.vertx.redis.impl.Reply;
import io.vertx.redis.impl.ReplyParser;
import io.vertx.redis.impl.ResponseTransform;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;

class RedisConnection {
    private final Context context;
    private static final Logger log = LoggerFactory.getLogger(RedisConnection.class);
    private final Queue<Command<?>> pending = new LinkedList();
    private final Queue<Command<?>> waiting = new LinkedList();
    private final ReplyParser replyParser;
    private final NetClient client;
    private final RedisOptions config;
    private final AtomicReference<State> state = new AtomicReference<State>(State.DISCONNECTED);
    private volatile NetSocket netSocket;

    public RedisConnection(Vertx vertx, RedisOptions config, RedisSubscriptions subscriptions) {
        this.context = vertx.getOrCreateContext();
        this.config = config;
        this.client = vertx.createNetClient(new NetClientOptions().setTcpKeepAlive(config.isTcpKeepAlive()).setTcpNoDelay(config.isTcpNoDelay()));
        this.replyParser = subscriptions != null ? new ReplyParser((Handler<Reply>)((Handler)reply -> {
            Reply[] data;
            if (reply.is('*') && (data = (Reply[])reply.data()) != null) {
                if (data.length == 3) {
                    if (data[0].is('$') && "message".equals(data[0].asType(String.class))) {
                        String channel = data[1].asType(String.class);
                        subscriptions.handleChannel(channel, data);
                        return;
                    }
                } else if (data.length == 4 && data[0].is('$') && "pmessage".equals(data[0].asType(String.class))) {
                    String pattern = data[1].asType(String.class);
                    subscriptions.handlePattern(pattern, data);
                    return;
                }
            }
            this.handleReply((Reply)reply);
        })) : new ReplyParser((Handler<Reply>)((Handler)this::handleReply));
    }

    private void connect() {
        if (this.state.compareAndSet(State.DISCONNECTED, State.CONNECTING)) {
            this.replyParser.reset();
            this.client.connect(this.config.getPort(), this.config.getHost(), asyncResult -> {
                if (asyncResult.failed()) {
                    this.runOnContext((Handler<Void>)((Handler)v -> {
                        if (this.state.compareAndSet(State.CONNECTING, State.ERROR)) {
                            RedisConnection.clearQueue(this.waiting, asyncResult.cause());
                            RedisConnection.clearQueue(this.pending, asyncResult.cause());
                            if (this.netSocket != null) {
                                this.netSocket.close();
                            }
                            this.state.set(State.DISCONNECTED);
                        }
                    }));
                } else {
                    this.netSocket = ((NetSocket)asyncResult.result()).handler((Handler)this.replyParser).closeHandler(v -> this.runOnContext((Handler<Void>)((Handler)v0 -> {
                        this.state.set(State.ERROR);
                        RedisConnection.clearQueue(this.waiting, "Connection closed");
                        RedisConnection.clearQueue(this.pending, "Connection closed");
                        this.state.set(State.DISCONNECTED);
                    }))).exceptionHandler(e -> this.runOnContext((Handler<Void>)((Handler)v0 -> {
                        this.state.set(State.ERROR);
                        RedisConnection.clearQueue(this.waiting, e);
                        RedisConnection.clearQueue(this.pending, e);
                        this.netSocket.close();
                        this.state.set(State.DISCONNECTED);
                    })));
                    this.runOnContext((Handler<Void>)((Handler)v -> {
                        RedisConnection.clearQueue(this.waiting, "Connection lost");
                        this.doAuth();
                    }));
                }
            });
        }
    }

    void disconnect(Handler<AsyncResult<Void>> closeHandler) {
        switch (this.state.get()) {
            case CONNECTING: 
            case CONNECTED: {
                Command<Void> cmd = new Command<Void>(this.context, RedisCommand.QUIT, null, Charset.defaultCharset(), ResponseTransform.NONE, Void.class);
                cmd.handler((Handler<AsyncResult<Void>>)((Handler)v -> this.runOnContext((Handler<Void>)((Handler)v0 -> {
                    if (this.state.compareAndSet(State.CONNECTED, State.ERROR)) {
                        RedisConnection.clearQueue(this.waiting, "Connection closed");
                        RedisConnection.clearQueue(this.pending, "Connection closed");
                        this.netSocket.close();
                        this.state.set(State.DISCONNECTED);
                        closeHandler.handle((Object)Future.succeededFuture());
                    }
                }))));
                this.send(cmd);
                break;
            }
            case ERROR: 
            case DISCONNECTED: {
                closeHandler.handle((Object)Future.succeededFuture());
            }
        }
    }

    void send(Command<?> command) {
        if (this.state.get() == State.DISCONNECTED) {
            this.connect();
        }
        this.runOnContext((Handler<Void>)((Handler)v -> {
            switch (this.state.get()) {
                case CONNECTED: {
                    for (int i = 0; i < command.getExpectedReplies(); ++i) {
                        this.waiting.add(command);
                    }
                    command.writeTo((WriteStream<Buffer>)this.netSocket);
                    break;
                }
                case CONNECTING: 
                case ERROR: 
                case DISCONNECTED: {
                    if (this.state.get() != State.CONNECTED) {
                        this.pending.add(command);
                        break;
                    }
                    this.send(command);
                }
            }
        }));
    }

    private void doAuth() {
        if (this.config.getAuth() != null) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.config.getAuth());
            Command<String> authCmd = new Command<String>(this.context, RedisCommand.AUTH, args, Charset.forName(this.config.getEncoding()), ResponseTransform.NONE, String.class).handler((Handler<AsyncResult<String>>)((Handler)auth -> {
                if (auth.failed()) {
                    RedisConnection.clearQueue(this.pending, auth.cause());
                    this.netSocket.close();
                    this.state.set(State.DISCONNECTED);
                } else {
                    this.doSelect();
                }
            }));
            this.runOnContext((Handler<Void>)((Handler)v -> {
                this.waiting.add(authCmd);
                authCmd.writeTo((WriteStream<Buffer>)this.netSocket);
            }));
        } else {
            this.doSelect();
        }
    }

    private void doSelect() {
        if (this.config.getSelect() != null) {
            ArrayList<Integer> args = new ArrayList<Integer>();
            args.add(this.config.getSelect());
            Command<String> selectCmd = new Command<String>(this.context, RedisCommand.SELECT, args, Charset.forName(this.config.getEncoding()), ResponseTransform.NONE, String.class).handler((Handler<AsyncResult<String>>)((Handler)select -> {
                if (select.failed()) {
                    RedisConnection.clearQueue(this.pending, select.cause());
                    this.netSocket.close();
                    this.state.set(State.DISCONNECTED);
                } else {
                    this.resendPending();
                }
            }));
            this.runOnContext((Handler<Void>)((Handler)v -> {
                this.waiting.add(selectCmd);
                selectCmd.writeTo((WriteStream<Buffer>)this.netSocket);
            }));
        } else {
            this.resendPending();
        }
    }

    private void resendPending() {
        this.runOnContext((Handler<Void>)((Handler)v -> {
            if (this.state.compareAndSet(State.CONNECTING, State.CONNECTED)) {
                Command<?> command;
                while ((command = this.pending.poll()) != null) {
                    for (int i = 0; i < command.getExpectedReplies(); ++i) {
                        this.waiting.add(command);
                    }
                    command.writeTo((WriteStream<Buffer>)this.netSocket);
                }
            }
        }));
    }

    private void handleReply(Reply reply) {
        this.runOnContext((Handler<Void>)((Handler)v -> {
            Command<?> cmd = this.waiting.poll();
            if (cmd != null) {
                switch (reply.type()) {
                    case 45: {
                        cmd.handle((AsyncResult<?>)Future.failedFuture((String)reply.asType(String.class)));
                        return;
                    }
                    case 43: {
                        switch (cmd.responseTransform()) {
                            case ARRAY: {
                                cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)new JsonArray().add(reply.asType(String.class))));
                                break;
                            }
                            default: {
                                cmd.handle((AsyncResult<?>)Future.succeededFuture(reply.asType(cmd.returnType())));
                            }
                        }
                        return;
                    }
                    case 36: {
                        switch (cmd.responseTransform()) {
                            case ARRAY: {
                                cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)new JsonArray().add(reply.asType(String.class, cmd.encoding()))));
                                break;
                            }
                            case INFO: {
                                String info = reply.asType(String.class, cmd.encoding());
                                if (info == null) {
                                    cmd.handle((AsyncResult<?>)Future.succeededFuture(null));
                                    break;
                                }
                                String[] lines = info.split("\\r?\\n");
                                JsonObject value = new JsonObject();
                                JsonObject section = null;
                                for (String line : lines) {
                                    if (line.length() == 0) {
                                        section = null;
                                        continue;
                                    }
                                    if (line.charAt(0) == '#') {
                                        section = new JsonObject();
                                        value.put(line.substring(2).toLowerCase(), section);
                                        continue;
                                    }
                                    int split = line.indexOf(58);
                                    if (section == null) {
                                        value.put(line.substring(0, split), line.substring(split + 1));
                                        continue;
                                    }
                                    section.put(line.substring(0, split), line.substring(split + 1));
                                }
                                cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)value));
                                break;
                            }
                            default: {
                                cmd.handle((AsyncResult<?>)Future.succeededFuture(reply.asType(cmd.returnType(), cmd.encoding())));
                            }
                        }
                        return;
                    }
                    case 42: {
                        switch (cmd.responseTransform()) {
                            case HASH: {
                                cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)reply.asType(JsonObject.class, cmd.encoding())));
                                break;
                            }
                            default: {
                                cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)reply.asType(JsonArray.class, cmd.encoding())));
                            }
                        }
                        return;
                    }
                    case 58: {
                        switch (cmd.responseTransform()) {
                            case ARRAY: {
                                cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)new JsonArray().add(reply.asType(Long.class))));
                                break;
                            }
                            default: {
                                cmd.handle((AsyncResult<?>)Future.succeededFuture(reply.asType(cmd.returnType())));
                            }
                        }
                        return;
                    }
                }
                cmd.handle((AsyncResult<?>)Future.failedFuture((String)"Unknown message type"));
            } else {
                log.error((Object)("No handler waiting for message: " + reply.asType(String.class)));
            }
        }));
    }

    private void runOnContext(Handler<Void> handler) {
        if (Vertx.currentContext() == this.context) {
            handler.handle(null);
        } else {
            this.context.runOnContext(handler);
        }
    }

    private static void clearQueue(Queue<Command<?>> q, String message) {
        Command<?> cmd;
        while ((cmd = q.poll()) != null) {
            cmd.handle((AsyncResult<?>)Future.failedFuture((String)message));
        }
    }

    private static void clearQueue(Queue<Command<?>> q, Throwable cause) {
        Command<?> cmd;
        while ((cmd = q.poll()) != null) {
            cmd.handle((AsyncResult<?>)Future.failedFuture((Throwable)cause));
        }
    }

    private static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        ERROR;

    }
}

