/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.redis.impl.Reply;

public class ReplyParser
implements Handler<Buffer> {
    private Buffer _buffer;
    private int _offset;
    private final String _encoding = "utf-8";
    private final Handler<Reply> handler;

    public ReplyParser(Handler<Reply> handler) {
        this.handler = handler;
    }

    public ReplyParser reset() {
        this._buffer = null;
        this._offset = 0;
        return this;
    }

    private Reply parseResult(byte type) throws IndexOutOfBoundsException {
        if (type == 43 || type == 45) {
            int end = this.packetEndOffset() - 1;
            int start = this._offset;
            this._offset = end + 2;
            if (end > this._buffer.length()) {
                this._offset = start;
                throw new IndexOutOfBoundsException("Wait for more data.");
            }
            if (type == 43) {
                return new Reply(type, this._buffer.getString(start, end, "utf-8"));
            }
            return new Reply(type, this._buffer.getString(start, end, "utf-8"));
        }
        if (type == 58) {
            int end = this.packetEndOffset() - 1;
            int start = this._offset;
            this._offset = end + 2;
            if (end > this._buffer.length()) {
                this._offset = start;
                throw new IndexOutOfBoundsException("Wait for more data.");
            }
            return new Reply(type, Long.parseLong(this._buffer.getString(start, end)));
        }
        if (type == 36) {
            int offset = this._offset - 1;
            int packetSize = this.parsePacketSize();
            if (packetSize == -1) {
                return new Reply(type, null);
            }
            int end = this._offset + packetSize;
            int start = this._offset;
            this._offset = end + 2;
            if (end > this._buffer.length()) {
                this._offset = offset;
                throw new IndexOutOfBoundsException("Wait for more data.");
            }
            return new Reply(type, this._buffer.getBuffer(start, end));
        }
        if (type == 42) {
            int offset = this._offset;
            int packetSize = this.parsePacketSize();
            if (packetSize == -1) {
                return new Reply(type, null);
            }
            if (packetSize > this.bytesRemaining()) {
                this._offset = offset - 1;
                throw new IndexOutOfBoundsException("Wait for more data.");
            }
            Reply reply = new Reply(type, packetSize);
            for (int i = 0; i < packetSize; ++i) {
                if (this._offset + 1 >= this._buffer.length()) {
                    throw new IndexOutOfBoundsException("Wait for more data.");
                }
                byte ntype = this._buffer.getByte(this._offset++);
                Reply res = this.parseResult(ntype);
                reply.set(i, res);
            }
            return reply;
        }
        throw new RuntimeException("Unsupported message type");
    }

    public void handle(Buffer buffer) {
        this.append(buffer);
        block6: while (true) {
            int offset = this._offset;
            try {
                if (this.bytesRemaining() < 4) break;
                byte type = this._buffer.getByte(this._offset++);
                switch (type) {
                    case 42: {
                        offset = this._offset - 1;
                    }
                    case 36: 
                    case 43: 
                    case 45: 
                    case 58: {
                        Reply ret = this.parseResult(type);
                        if (ret == null) break block6;
                        this.handler.handle((Object)ret);
                    }
                }
            }
            catch (IndexOutOfBoundsException err) {
                this._offset = offset;
                break;
            }
        }
    }

    private void append(Buffer newBuffer) {
        if (newBuffer == null) {
            return;
        }
        if (this._buffer == null) {
            this._buffer = newBuffer;
            return;
        }
        if (this._offset >= this._buffer.length()) {
            this._buffer = newBuffer;
            this._offset = 0;
            return;
        }
        if (this._offset > 0) {
            this._buffer = this._buffer.getBuffer(this._offset, this._buffer.length());
        }
        this._buffer.appendBuffer(newBuffer);
        this._offset = 0;
    }

    private int parsePacketSize() throws IndexOutOfBoundsException {
        int end = this.packetEndOffset();
        String value = this._buffer.getString(this._offset, end - 1, "utf-8");
        this._offset = end + 1;
        long size = Long.parseLong(value);
        if (size > Integer.MAX_VALUE) {
            throw new RuntimeException("Cannot allocate more than 2147483647 bytes");
        }
        if (size < Integer.MIN_VALUE) {
            throw new RuntimeException("Cannot allocate less than -2147483648 bytes");
        }
        return (int)size;
    }

    private int packetEndOffset() throws IndexOutOfBoundsException {
        int offset = this._offset;
        if (offset + 1 >= this._buffer.length()) {
            throw new IndexOutOfBoundsException("Not enough data.");
        }
        while (this._buffer.getByte(offset) != 13 && this._buffer.getByte(offset + 1) != 10) {
            if (++offset + 1 != this._buffer.length()) continue;
            throw new IndexOutOfBoundsException("didn't see LF after NL reading multi bulk count (" + offset + " => " + this._buffer.length() + ", " + this._offset + ")");
        }
        return ++offset;
    }

    private int bytesRemaining() {
        return this._buffer.length() - this._offset < 0 ? 0 : this._buffer.length() - this._offset;
    }

    private static class IndexOutOfBoundsException
    extends Exception {
        IndexOutOfBoundsException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

