/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Supplier;
import org.apache.sshd.common.util.Transformer;

public interface KeyIdentityProvider {
    public static final KeyIdentityProvider EMPTY_KEYS_PROVIDER = new KeyIdentityProvider(){

        @Override
        public Iterable<KeyPair> loadKeys() {
            return Collections.emptyList();
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public Iterable<KeyPair> loadKeys();

    public static final class Utils {
        public static final Transformer<KeyIdentityProvider, Iterable<KeyPair>> LOADER = new Transformer<KeyIdentityProvider, Iterable<KeyPair>>(){

            @Override
            public Iterable<KeyPair> transform(KeyIdentityProvider p) {
                return p == null ? Collections.emptyList() : p.loadKeys();
            }
        };

        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static Iterator<KeyPair> iteratorOf(ClientSession session) {
            return session == null ? Collections.emptyIterator() : Utils.iteratorOf(session.getRegisteredIdentities(), session.getKeyPairProvider());
        }

        public static Iterator<KeyPair> iteratorOf(KeyIdentityProvider identities, KeyIdentityProvider keys) {
            return Utils.iteratorOf(Utils.resolveKeyIdentityProvider(identities, keys));
        }

        public static Iterator<KeyPair> iteratorOf(KeyIdentityProvider provider) {
            return GenericUtils.iteratorOf(provider == null ? null : provider.loadKeys());
        }

        public static KeyIdentityProvider resolveKeyIdentityProvider(KeyIdentityProvider identities, KeyIdentityProvider keys) {
            if (keys == null || identities == keys) {
                return identities;
            }
            if (identities == null) {
                return keys;
            }
            return Utils.multiProvider(identities, keys);
        }

        public static KeyIdentityProvider multiProvider(KeyIdentityProvider ... providers) {
            return GenericUtils.isEmpty(providers) ? EMPTY_KEYS_PROVIDER : Utils.multiProvider(Arrays.asList(providers));
        }

        public static KeyIdentityProvider multiProvider(Collection<? extends KeyIdentityProvider> providers) {
            return GenericUtils.isEmpty(providers) ? EMPTY_KEYS_PROVIDER : Utils.wrap(Utils.iterableOf(providers));
        }

        public static Iterable<KeyPair> iterableOf(Collection<? extends KeyIdentityProvider> providers) {
            if (GenericUtils.isEmpty(providers)) {
                return Collections.emptyList();
            }
            ArrayList<2> suppliers = new ArrayList<2>(providers.size());
            for (final KeyIdentityProvider keyIdentityProvider : providers) {
                if (keyIdentityProvider == null) continue;
                suppliers.add(new Supplier<Iterable<KeyPair>>(){

                    @Override
                    public Iterable<KeyPair> get() {
                        return keyIdentityProvider.loadKeys();
                    }
                });
            }
            if (GenericUtils.isEmpty(suppliers)) {
                return Collections.emptyList();
            }
            return GenericUtils.multiIterableSuppliers(suppliers);
        }

        public static KeyIdentityProvider wrap(KeyPair ... pairs) {
            return GenericUtils.isEmpty(pairs) ? EMPTY_KEYS_PROVIDER : Utils.wrap(Arrays.asList(pairs));
        }

        public static KeyIdentityProvider wrap(final Iterable<KeyPair> pairs) {
            return pairs == null ? EMPTY_KEYS_PROVIDER : new KeyIdentityProvider(){

                @Override
                public Iterable<KeyPair> loadKeys() {
                    return pairs;
                }
            };
        }
    }
}

