/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jdbc.JDBCAuth;
import io.vertx.ext.auth.jdbc.JDBCHashStrategy;
import io.vertx.ext.auth.jdbc.impl.JDBCUser;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Consumer;

public class JDBCAuthImpl
implements AuthProvider,
JDBCAuth {
    private static final Logger log = LoggerFactory.getLogger(JDBCAuthImpl.class);
    private JDBCClient client;
    private String authenticateQuery = "SELECT PASSWORD, PASSWORD_SALT FROM USER WHERE USERNAME = ?";
    private String rolesQuery = "SELECT ROLE FROM USER_ROLES WHERE USERNAME = ?";
    private String permissionsQuery = "SELECT PERM FROM ROLES_PERMS RP, USER_ROLES UR WHERE UR.USERNAME = ? AND UR.ROLE = RP.ROLE";
    private String rolePrefix = "role:";
    private JDBCHashStrategy strategy = new DefaultHashStrategy();
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    public JDBCAuthImpl(JDBCClient client) {
        this.client = client;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        String username = authInfo.getString("username");
        if (username == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"authInfo must contain username in 'username' field"));
            return;
        }
        String password = authInfo.getString("password");
        if (password == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"authInfo must contain password in 'password' field"));
            return;
        }
        this.executeQuery(this.authenticateQuery, new JsonArray().add(username), resultHandler, rs -> {
            switch (rs.getNumRows()) {
                case 0: {
                    resultHandler.handle((Object)Future.failedFuture((String)"Invalid username/password"));
                    break;
                }
                case 1: {
                    JsonArray row = (JsonArray)rs.getResults().get(0);
                    String hashedStoredPwd = this.strategy.getHashedStoredPwd(row);
                    String salt = this.strategy.getSalt(row);
                    String hashedPassword = this.strategy.computeHash(password, salt);
                    if (hashedStoredPwd.equals(hashedPassword)) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)((Object)new JDBCUser(username, this, this.rolePrefix))));
                        break;
                    }
                    resultHandler.handle((Object)Future.failedFuture((String)"Invalid username/password"));
                    break;
                }
                default: {
                    resultHandler.handle((Object)Future.failedFuture((String)"Failure in authentication"));
                }
            }
        });
    }

    @Override
    public JDBCAuth setAuthenticationQuery(String authenticationQuery) {
        this.authenticateQuery = authenticationQuery;
        return this;
    }

    @Override
    public JDBCAuth setRolesQuery(String rolesQuery) {
        this.rolesQuery = rolesQuery;
        return this;
    }

    @Override
    public JDBCAuth setPermissionsQuery(String permissionsQuery) {
        this.permissionsQuery = permissionsQuery;
        return this;
    }

    @Override
    public JDBCAuth setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
        return this;
    }

    @Override
    public JDBCAuth setHashStrategy(JDBCHashStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    protected <T> void executeQuery(String query, JsonArray params, Handler<AsyncResult<T>> resultHandler, Consumer<ResultSet> resultSetConsumer) {
        this.client.getConnection(res -> {
            if (res.succeeded()) {
                SQLConnection conn = (SQLConnection)res.result();
                conn.queryWithParams(query, params, queryRes -> {
                    if (queryRes.succeeded()) {
                        ResultSet rs = (ResultSet)queryRes.result();
                        resultSetConsumer.accept(rs);
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)queryRes.cause()));
                    }
                    conn.close(closeRes -> {});
                });
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    public static String bytesToHex(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int x = 0xFF & bytes[i];
            chars[i * 2] = HEX_CHARS[x >>> 4];
            chars[1 + i * 2] = HEX_CHARS[0xF & x];
        }
        return new String(chars);
    }

    public static String computeHash(String password, String salt, String algo) {
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            String concat = (salt == null ? "" : salt) + password;
            byte[] bHash = md.digest(concat.getBytes(StandardCharsets.UTF_8));
            return JDBCAuthImpl.bytesToHex(bHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new VertxException((Throwable)e);
        }
    }

    String getRolesQuery() {
        return this.rolesQuery;
    }

    String getPermissionsQuery() {
        return this.permissionsQuery;
    }

    private class DefaultHashStrategy
    implements JDBCHashStrategy {
        private DefaultHashStrategy() {
        }

        @Override
        public String computeHash(String password, String salt) {
            return JDBCAuthImpl.computeHash(password, salt, "SHA-512");
        }

        @Override
        public String getHashedStoredPwd(JsonArray row) {
            return row.getString(0);
        }

        @Override
        public String getSalt(JsonArray row) {
            return row.getString(1);
        }
    }
}

