/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.impl.AuthHandlerImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class OAuth2AuthHandlerImpl
extends AuthHandlerImpl
implements OAuth2AuthHandler {
    private final String host;
    private Route callback;

    public OAuth2AuthHandlerImpl(OAuth2Auth authProvider, String host) {
        super((AuthProvider)authProvider);
        this.host = host;
    }

    public void handle(RoutingContext ctx) {
        User user = ctx.user();
        if (user != null) {
            if (((OAuth2Auth)this.authProvider).hasJWTToken()) {
                this.authorise(user, ctx);
            } else {
                ctx.next();
            }
        } else {
            ctx.response().putHeader("Location", this.authURI(ctx.normalisedPath(), (String)ctx.get("state"))).setStatusCode(302).end();
        }
    }

    @Override
    public String authURI(String redirectURL, String state) {
        if (this.callback == null) {
            throw new NullPointerException("callback is null");
        }
        StringBuilder scopes = new StringBuilder();
        try {
            for (String authority : this.authorities) {
                scopes.append(URLEncoder.encode(authority, "UTF-8"));
                scopes.append(',');
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (scopes.length() > 0) {
            scopes.setLength(scopes.length() - 1);
        }
        return ((OAuth2Auth)this.authProvider).authorizeURL(new JsonObject().put("redirect_uri", this.host + this.callback.getPath() + "?redirect_uri=" + redirectURL).put("scope", scopes.toString()).put("state", state));
    }

    @Override
    public OAuth2AuthHandler setupCallback(Route route) {
        this.callback = route;
        route.handler((Handler<RoutingContext>)((Handler)ctx -> {
            String code = ctx.request().getParam("code");
            if (code == null) {
                ctx.fail(400);
                return;
            }
            String relative_redirect_uri = ctx.request().getParam("redirect_uri");
            String redirect_uri = this.host + this.callback.getPath() + "?redirect_uri=" + relative_redirect_uri;
            ((OAuth2Auth)this.authProvider).getToken(new JsonObject().put("code", code).put("redirect_uri", redirect_uri), res -> {
                if (res.failed()) {
                    ctx.fail(res.cause());
                } else {
                    ctx.setUser((User)res.result());
                    ctx.reroute(relative_redirect_uri);
                }
            });
        }));
        return this;
    }
}

