/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AbstractSubscription;
import com.mongodb.async.client.Observer;

class SingleResultCallbackSubscription<TResult>
extends AbstractSubscription<TResult> {
    private final Block<SingleResultCallback<TResult>> block;
    private boolean completed;

    public SingleResultCallbackSubscription(Block<SingleResultCallback<TResult>> block, Observer<? super TResult> observer) {
        super(observer);
        this.block = block;
        observer.onSubscribe(this);
    }

    @Override
    void requestInitialData() {
        this.block.apply((Object)new SingleResultCallback<TResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResult(TResult result, Throwable t) {
                if (t != null) {
                    SingleResultCallbackSubscription.this.onError(t);
                } else {
                    SingleResultCallbackSubscription singleResultCallbackSubscription = SingleResultCallbackSubscription.this;
                    synchronized (singleResultCallbackSubscription) {
                        SingleResultCallbackSubscription.this.completed = true;
                    }
                    SingleResultCallbackSubscription.this.addToQueue(result);
                }
            }
        });
    }

    @Override
    boolean checkCompleted() {
        return this.completed;
    }
}

