/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.docgen;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;

class DocWriter
extends Writer {
    final Writer delegate;
    private int status;
    private boolean literal;

    DocWriter(Writer delegate) {
        this.delegate = delegate;
        this.status = 0;
        this.literal = false;
    }

    void resetParagraph() {
        this.status = 0;
        this.literal = false;
    }

    void literalMode() {
        this.literal = true;
    }

    void commentMode() {
        this.literal = false;
    }

    @Override
    public void write(int c) {
        try {
            super.write(c);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void write(char[] cbuf) {
        try {
            super.write(cbuf);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void write(String str) {
        try {
            super.write(str);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void write(String str, int off, int len) {
        try {
            super.write(str, off, len);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public DocWriter append(CharSequence csq) {
        try {
            return (DocWriter)super.append(csq);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public DocWriter append(CharSequence csq, int start, int end) {
        try {
            return (DocWriter)super.append(csq, start, end);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public DocWriter append(char c) {
        try {
            return (DocWriter)super.append(c);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        try {
            if (this.literal) {
                while (off < len) {
                    this.delegate.write(cbuf[off++]);
                }
            } else {
                block7: while (off < len) {
                    char c = cbuf[off++];
                    switch (c) {
                        case '\n': {
                            this.status = 1;
                            this.delegate.write(c);
                            continue block7;
                        }
                        case ' ': {
                            if (this.status == 1) {
                                this.status = 2;
                                continue block7;
                            }
                            this.delegate.write(c);
                            continue block7;
                        }
                    }
                    this.delegate.write(c);
                    if (this.status != 1) continue;
                    this.status = 2;
                }
            }
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

