/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.docgen;

import com.sun.tools.javac.code.Type;
import io.vertx.docgen.BaseProcessor;
import io.vertx.docgen.Coordinate;
import java.io.StringWriter;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

public class JavaDocGenProcessor
extends BaseProcessor {
    @Override
    protected void handleGen(PackageElement docElt) {
        StringWriter buffer = new StringWriter();
        this.process(buffer, docElt);
        this.write(docElt, buffer.toString());
    }

    @Override
    protected String getName() {
        return "java";
    }

    @Override
    protected String resolveTypeLink(TypeElement elt, Coordinate coordinate) {
        return "../../apidocs/" + elt.getQualifiedName().toString().replace('.', '/') + ".html";
    }

    @Override
    protected String resolveConstructorLink(ExecutableElement elt, Coordinate coordinate) {
        return this.toExecutableLink(elt, elt.getEnclosingElement().getSimpleName().toString());
    }

    @Override
    protected String resolveMethodLink(ExecutableElement elt, Coordinate coordinate) {
        return this.toExecutableLink(elt, elt.getSimpleName().toString());
    }

    private String toExecutableLink(ExecutableElement elt, String name) {
        TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
        String link = this.resolveTypeLink(typeElt, null);
        StringBuilder anchor = new StringBuilder("#");
        anchor.append(name).append('-');
        TypeMirror type = elt.asType();
        ExecutableType methodType = (ExecutableType)this.processingEnv.getTypeUtils().erasure(type);
        List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeMirror typeOfParameter;
            if (i > 0) {
                anchor.append('-');
            }
            if ((typeOfParameter = parameterTypes.get(i)) instanceof Type && ((Type)typeOfParameter).isAnnotated()) {
                anchor.append(((Type)typeOfParameter).unannotatedType().toString());
                continue;
            }
            anchor.append(typeOfParameter.toString());
        }
        anchor.append('-');
        return link + anchor;
    }

    @Override
    protected String resolveFieldLink(VariableElement elt, Coordinate coordinate) {
        TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
        String link = this.resolveTypeLink(typeElt, null);
        return link + "#" + elt.getSimpleName();
    }

    @Override
    protected String renderSource(ExecutableElement elt, String source) {
        return this.defaultRenderSource(elt, source);
    }
}

