/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.impl.AsyncMap;
import io.vertx.servicediscovery.spi.ServiceDiscoveryBackend;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class DefaultServiceDiscoveryBackend
implements ServiceDiscoveryBackend {
    private AsyncMap<String, String> registry;

    @Override
    public void init(Vertx vertx, JsonObject config) {
        this.registry = new AsyncMap(vertx, "service.registry");
    }

    @Override
    public void store(Record record, Handler<AsyncResult<Record>> resultHandler) {
        String uuid = UUID.randomUUID().toString();
        if (record.getRegistration() != null) {
            throw new IllegalArgumentException("The record has already been registered");
        }
        record.setRegistration(uuid);
        this.registry.put(uuid, record.toJson().encode(), (Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)record));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    @Override
    public void remove(Record record, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        this.remove(record.getRegistration(), resultHandler);
    }

    @Override
    public void remove(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(uuid, "No registration id in the record");
        this.registry.remove(uuid, (Handler<AsyncResult<String>>)((Handler)ar -> {
            if (ar.succeeded()) {
                if (ar.result() == null) {
                    resultHandler.handle((Object)Future.failedFuture((String)("Record '" + uuid + "' not found")));
                } else {
                    resultHandler.handle((Object)Future.succeededFuture((Object)new Record(new JsonObject((String)ar.result()))));
                }
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    @Override
    public void update(Record record, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        this.registry.put(record.getRegistration(), record.toJson().encode(), (Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    @Override
    public void getRecords(Handler<AsyncResult<List<Record>>> resultHandler) {
        this.registry.getAll((Handler<AsyncResult<Map<String, String>>>)((Handler)ar -> {
            if (ar.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture(((Map)ar.result()).values().stream().map(s -> new Record(new JsonObject(s))).collect(Collectors.toList())));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    @Override
    public void getRecord(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        this.registry.get(uuid, (Handler<AsyncResult<String>>)((Handler)ar -> {
            if (ar.succeeded()) {
                if (ar.result() != null) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)new Record(new JsonObject((String)ar.result()))));
                } else {
                    resultHandler.handle((Object)Future.succeededFuture(null));
                }
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }
}

