/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.types.DataSource;
import java.util.Objects;

@VertxGen
public interface JDBCDataSource
extends DataSource {
    public static final String DEFAULT_TYPE = "jdbc";

    public static Record createRecord(String name, JsonObject location, JsonObject metadata) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(location);
        Record record = new Record().setName(name).setType("datasource").setLocation(location);
        if (metadata != null) {
            record.setMetadata(metadata);
        }
        record.setMetadata(new JsonObject().put("datasource.type", DEFAULT_TYPE));
        return record;
    }

    public static void getJDBCClient(ServiceDiscovery discovery, JsonObject filter, Handler<AsyncResult<JDBCClient>> resultHandler) {
        discovery.getRecord(filter, (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.failed() || ar.result() == null) {
                resultHandler.handle((Object)Future.failedFuture((String)"No matching record"));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(discovery.getReference((Record)ar.result()).get()));
            }
        }));
    }

    public static void getJDBCClient(ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration, Handler<AsyncResult<JDBCClient>> resultHandler) {
        discovery.getRecord(filter, (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.failed() || ar.result() == null) {
                resultHandler.handle((Object)Future.failedFuture((String)"No matching record"));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(discovery.getReferenceWithConfiguration((Record)ar.result(), consumerConfiguration).get()));
            }
        }));
    }
}

