/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.StartTLSOptions;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.StatusCode;

class SMTPInitialDialogue {
    private static final Logger log = LoggerFactory.getLogger(SMTPInitialDialogue.class);
    private SMTPConnection connection;
    private Handler<Throwable> errorHandler;
    private Handler<Void> finishedHandler;
    private MailConfig config;
    private String hostname;

    public SMTPInitialDialogue(SMTPConnection connection, MailConfig config, String hostname, Handler<Void> finishedHandler, Handler<Throwable> errorHandler) {
        this.connection = connection;
        this.config = config;
        this.hostname = hostname;
        this.finishedHandler = finishedHandler;
        this.errorHandler = errorHandler;
    }

    public void start(String message) {
        log.debug((Object)("server greeting: " + message));
        if (StatusCode.isStatusOk(message)) {
            if (!this.config.isDisableEsmtp()) {
                this.ehloCmd();
            } else {
                this.heloCmd();
            }
        } else {
            this.handleError("got error response " + message);
        }
    }

    private void ehloCmd() {
        this.connection.write("EHLO " + this.hostname, (Handler<String>)((Handler)message -> {
            log.debug((Object)("EHLO result: " + message));
            if (StatusCode.isStatusOk(message)) {
                this.connection.parseCapabilities((String)message);
                if (this.connection.getCapa().isStartTLS() && !this.connection.isSsl() && (this.config.getStarttls() == StartTLSOptions.REQUIRED || this.config.getStarttls() == StartTLSOptions.OPTIONAL)) {
                    this.startTLSCmd();
                } else {
                    this.finished();
                }
            } else {
                this.heloCmd();
            }
        }));
    }

    private void heloCmd() {
        this.connection.write("HELO " + this.hostname, (Handler<String>)((Handler)message -> {
            log.debug((Object)("HELO result: " + message));
            if (StatusCode.isStatusOk(message)) {
                this.finished();
            } else {
                this.handleError("HELO failed with " + message);
            }
        }));
    }

    private void handleError(String message) {
        log.debug((Object)("handleError:" + message));
        this.errorHandler.handle((Object)new NoStackTraceThrowable(message));
    }

    private void startTLSCmd() {
        this.connection.write("STARTTLS", (Handler<String>)((Handler)message -> {
            log.debug((Object)("STARTTLS result: " + message));
            this.connection.upgradeToSsl((Handler<Void>)((Handler)v -> {
                log.debug((Object)"ssl started");
                this.ehloCmd();
            }));
        }));
    }

    private void finished() {
        if (this.connection.isSsl() || this.config.getStarttls() != StartTLSOptions.REQUIRED) {
            this.finishedHandler.handle(null);
        } else {
            log.warn((Object)"STARTTLS required but not supported by server");
            this.handleError("STARTTLS required but not supported by server");
        }
    }
}

