/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.Helper;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.Member;
import io.vertx.codetrans.expression.NullLiteralModel;
import io.vertx.codetrans.expression.StringLiteralModel;
import java.util.Collections;
import java.util.List;

public class JsonObjectLiteralModel
extends ExpressionModel {
    private final List<Member> entries;

    public JsonObjectLiteralModel(CodeBuilder builder) {
        this(builder, Collections.emptyList());
    }

    private JsonObjectLiteralModel(CodeBuilder builder, List<Member> entries) {
        super(builder);
        this.entries = entries;
    }

    public Iterable<Member> getMembers() {
        return this.entries;
    }

    @Override
    public ExpressionModel as(TypeInfo type) {
        if (type.getKind() != ClassKind.JSON_OBJECT) {
            throw new UnsupportedOperationException();
        }
        return this;
    }

    @Override
    public ExpressionModel onMethodInvocation(TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<ExpressionModel> argumentModels, List<TypeInfo> argumenTypes) {
        String methodName = method.getName();
        StringLiteralModel name = (StringLiteralModel)argumentModels.get(0);
        switch (methodName) {
            case "put": {
                return new JsonObjectLiteralModel(this.builder, Helper.append(this.entries, new Member.Single(name.value).append(argumentModels.get(1))));
            }
            case "putNull": {
                return new JsonObjectLiteralModel(this.builder, Helper.append(this.entries, new Member.Single(name.value).append(new NullLiteralModel(this.builder))));
            }
        }
        throw new UnsupportedOperationException("Method " + method + " not yet implemented");
    }

    @Override
    public void render(CodeWriter writer) {
        writer.renderJsonObject(this);
    }
}

