/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.NullLiteralModel;
import io.vertx.codetrans.expression.StringLiteralModel;
import java.util.List;

public class JsonObjectModel
extends ExpressionModel {
    final ExpressionModel expression;

    public JsonObjectModel(CodeBuilder builder, ExpressionModel expression) {
        super(builder);
        this.expression = expression;
    }

    @Override
    public ExpressionModel onMethodInvocation(TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<ExpressionModel> argumentModels, List<TypeInfo> argumenTypes) {
        String methodName;
        switch (methodName = method.getName()) {
            case "put": {
                return this.builder.render((CodeWriter writer) -> {
                    StringLiteralModel name = (StringLiteralModel)argumentModels.get(0);
                    writer.renderJsonObjectAssign(this.expression, name.value, (ExpressionModel)argumentModels.get(1));
                });
            }
            case "putNull": {
                return this.builder.render((CodeWriter writer) -> {
                    StringLiteralModel name = (StringLiteralModel)argumentModels.get(0);
                    writer.renderJsonObjectAssign(this.expression, name.value, new NullLiteralModel(this.builder));
                });
            }
            case "encodePrettily": 
            case "encode": {
                return this.builder.jsonObjectEncoder(this.expression);
            }
            case "getString": 
            case "getJsonObject": 
            case "getInteger": 
            case "getLong": 
            case "getFloat": 
            case "getDouble": 
            case "getBoolean": 
            case "getJsonArray": 
            case "getValue": {
                if (argumentModels.size() == 1) {
                    return this.builder.render((CodeWriter writer) -> {
                        StringLiteralModel name = (StringLiteralModel)argumentModels.get(0);
                        writer.renderJsonObjectMemberSelect(this.expression, name.value);
                    });
                }
                throw this.unsupported("Invalid arguments " + argumentModels);
            }
        }
        throw this.unsupported("Method " + method);
    }

    @Override
    public void render(CodeWriter writer) {
        this.expression.render(writer);
    }
}

