/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.shell.term.HttpTermOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import java.util.Base64;

public class HttpTermOptionsConverter {
    public static void fromJson(JsonObject json, HttpTermOptions obj) {
        if (json.getValue("charset") instanceof String) {
            obj.setCharset((String)json.getValue("charset"));
        }
        if (json.getValue("intputrc") instanceof String) {
            obj.setIntputrc((String)json.getValue("intputrc"));
        }
        if (json.getValue("shellHtmlResource") instanceof String) {
            obj.setShellHtmlResource(Buffer.buffer((byte[])Base64.getDecoder().decode((String)json.getValue("shellHtmlResource"))));
        }
        if (json.getValue("sockJSHandlerOptions") instanceof JsonObject) {
            obj.setSockJSHandlerOptions(new SockJSHandlerOptions((JsonObject)json.getValue("sockJSHandlerOptions")));
        }
        if (json.getValue("sockJSPath") instanceof String) {
            obj.setSockJSPath((String)json.getValue("sockJSPath"));
        }
        if (json.getValue("termJsResource") instanceof String) {
            obj.setTermJsResource(Buffer.buffer((byte[])Base64.getDecoder().decode((String)json.getValue("termJsResource"))));
        }
        if (json.getValue("vertsShellJsResource") instanceof String) {
            obj.setVertsShellJsResource(Buffer.buffer((byte[])Base64.getDecoder().decode((String)json.getValue("vertsShellJsResource"))));
        }
    }

    public static void toJson(HttpTermOptions obj, JsonObject json) {
        if (obj.getCharset() != null) {
            json.put("charset", obj.getCharset());
        }
        if (obj.getIntputrc() != null) {
            json.put("intputrc", obj.getIntputrc());
        }
        if (obj.getShellHtmlResource() != null) {
            json.put("shellHtmlResource", obj.getShellHtmlResource().getBytes());
        }
        if (obj.getSockJSPath() != null) {
            json.put("sockJSPath", obj.getSockJSPath());
        }
        if (obj.getTermJsResource() != null) {
            json.put("termJsResource", obj.getTermJsResource().getBytes());
        }
        if (obj.getVertsShellJsResource() != null) {
            json.put("vertsShellJsResource", obj.getVertsShellJsResource().getBytes());
        }
    }
}

