/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.file;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.ReadStreamAdapter;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;

public class AsyncFile
implements ReadStream<Buffer>,
WriteStream<Buffer> {
    final io.vertx.core.file.AsyncFile delegate;
    private Observable<Buffer> observable;

    public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            ReadStreamAdapter<io.vertx.core.buffer.Buffer, Buffer> adapter = new ReadStreamAdapter<io.vertx.core.buffer.Buffer, Buffer>(this, conv);
            this.observable = Observable.create(adapter);
        }
        return this.observable;
    }

    @Override
    public void end(Buffer t) {
        this.delegate.end((Object)((io.vertx.core.buffer.Buffer)t.getDelegate()));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    public AsyncFile handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    public AsyncFile pause() {
        this.delegate.pause();
        return this;
    }

    public AsyncFile resume() {
        this.delegate.resume();
        return this;
    }

    public AsyncFile endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public AsyncFile write(Buffer data) {
        this.delegate.write((io.vertx.core.buffer.Buffer)data.getDelegate());
        return this;
    }

    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public AsyncFile drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Observable<Void> closeObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.close(handler.toHandler());
        return handler;
    }

    public AsyncFile write(Buffer buffer, long position, Handler<AsyncResult<Void>> handler) {
        this.delegate.write((io.vertx.core.buffer.Buffer)buffer.getDelegate(), position, handler);
        return this;
    }

    public Observable<Void> writeObservable(Buffer buffer, long position) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.write(buffer, position, handler.toHandler());
        return handler;
    }

    public AsyncFile read(Buffer buffer, int offset, long position, int length, final Handler<AsyncResult<Buffer>> handler) {
        this.delegate.read((io.vertx.core.buffer.Buffer)buffer.getDelegate(), offset, position, length, (Handler)new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Buffer.newInstance((io.vertx.core.buffer.Buffer)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Observable<Buffer> readObservable(Buffer buffer, int offset, long position, int length) {
        ObservableFuture<Buffer> handler = RxHelper.observableFuture();
        this.read(buffer, offset, position, length, handler.toHandler());
        return handler;
    }

    public AsyncFile flush() {
        this.delegate.flush();
        return this;
    }

    public AsyncFile flush(Handler<AsyncResult<Void>> handler) {
        this.delegate.flush(handler);
        return this;
    }

    public Observable<Void> flushObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.flush(handler.toHandler());
        return handler;
    }

    public AsyncFile setReadPos(long readPos) {
        this.delegate.setReadPos(readPos);
        return this;
    }

    public AsyncFile setWritePos(long writePos) {
        this.delegate.setWritePos(writePos);
        return this;
    }

    public AsyncFile setReadBufferSize(int readBufferSize) {
        this.delegate.setReadBufferSize(readBufferSize);
        return this;
    }

    public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
        return arg != null ? new AsyncFile(arg) : null;
    }
}

