/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Handlebars;
import org.apache.commons.lang3.StringEscapeUtils;

public interface EscapingStrategy {
    public static final EscapingStrategy HTML_ENTITY = new EscapingStrategy(){

        @Override
        public CharSequence escape(CharSequence value) {
            return Handlebars.Utils.escapeExpression(value);
        }
    };
    public static final EscapingStrategy CSV = new EscapingStrategy(){

        @Override
        public CharSequence escape(CharSequence value) {
            return value == null ? null : StringEscapeUtils.escapeCsv(value.toString());
        }
    };
    public static final EscapingStrategy XML = new EscapingStrategy(){

        @Override
        public CharSequence escape(CharSequence value) {
            return value == null ? null : StringEscapeUtils.escapeXml(value.toString());
        }
    };
    public static final EscapingStrategy JS = new EscapingStrategy(){

        @Override
        public CharSequence escape(CharSequence value) {
            return value == null ? null : StringEscapeUtils.escapeEcmaScript(value.toString());
        }
    };
    public static final EscapingStrategy NOOP = new EscapingStrategy(){

        @Override
        public CharSequence escape(CharSequence value) {
            return value;
        }
    };

    public CharSequence escape(CharSequence var1);
}

