/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.Locale;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.templ.ThymeleafTemplateEngine;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.StringTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public class ThymeleafTemplateEngineImpl
implements ThymeleafTemplateEngine {
    private final TemplateEngine templateEngine = new TemplateEngine();
    private ResourceTemplateResolver templateResolver;

    public ThymeleafTemplateEngineImpl() {
        ResourceTemplateResolver templateResolver = new ResourceTemplateResolver();
        templateResolver.setTemplateMode(ThymeleafTemplateEngine.DEFAULT_TEMPLATE_MODE);
        this.templateResolver = templateResolver;
        this.templateEngine.setTemplateResolver(templateResolver);
    }

    @Override
    public ThymeleafTemplateEngine setMode(TemplateMode mode) {
        this.templateResolver.setTemplateMode(TemplateMode.HTML);
        return this;
    }

    @Override
    public TemplateEngine getThymeleafTemplateEngine() {
        return this.templateEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RoutingContext context, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        final Buffer buffer = Buffer.buffer();
        try {
            HashMap<String, RoutingContext> data = new HashMap<String, RoutingContext>();
            data.put("context", context);
            data.putAll(context.data());
            ThymeleafTemplateEngineImpl thymeleafTemplateEngineImpl = this;
            synchronized (thymeleafTemplateEngineImpl) {
                this.templateResolver.setVertx(context.vertx());
                List acceptableLocales = context.acceptableLocales();
                Locale locale = acceptableLocales.size() == 0 ? Locale.create() : (Locale)acceptableLocales.get(0);
                this.templateEngine.process(templateFileName, (IContext)new WebIContext(data, locale), new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) throws IOException {
                        buffer.appendString(new String(cbuf, off, len));
                    }

                    @Override
                    public void flush() throws IOException {
                    }

                    @Override
                    public void close() throws IOException {
                    }
                });
            }
            handler.handle((Object)Future.succeededFuture((Object)buffer));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    private static class ResourceTemplateResolver
    extends StringTemplateResolver {
        private Vertx vertx;

        public ResourceTemplateResolver() {
            this.setName("vertx-web/Thymeleaf3");
        }

        void setVertx(Vertx vertx) {
            this.vertx = vertx;
        }

        @Override
        protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
            String str = Utils.readFileToString((Vertx)this.vertx, (String)template);
            return new StringTemplateResource(str);
        }
    }

    private static class WebIContext
    implements IContext {
        private final Map<String, Object> data;
        private final java.util.Locale locale;

        private WebIContext(Map<String, Object> data, Locale locale) {
            this.data = data;
            this.locale = new java.util.Locale(locale.language(), locale.country(), locale.variant());
        }

        @Override
        public java.util.Locale getLocale() {
            return this.locale;
        }

        @Override
        public boolean containsVariable(String name) {
            return this.data.containsKey(name);
        }

        @Override
        public Set<String> getVariableNames() {
            return this.data.keySet();
        }

        @Override
        public Object getVariable(String name) {
            return this.data.get(name);
        }
    }
}

