/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.inline.NoOpInliner;
import org.thymeleaf.standard.inline.StandardCSSInliner;
import org.thymeleaf.standard.inline.StandardInlineMode;
import org.thymeleaf.standard.inline.StandardJavaScriptInliner;
import org.thymeleaf.standard.inline.StandardTextInliner;
import org.thymeleaf.standard.processor.AbstractStandardTextInlineSettingTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;

public final class StandardInlineTextualTagProcessor
extends AbstractStandardTextInlineSettingTagProcessor {
    public static final int PRECEDENCE = 1000;
    public static final String ATTR_NAME = "inline";

    public StandardInlineTextualTagProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, dialectPrefix, ATTR_NAME, 1000);
        Validate.isTrue(templateMode.isText(), "Template mode must be a textual one");
    }

    @Override
    protected IInliner getInliner(ITemplateContext context, StandardInlineMode inlineMode) {
        TemplateMode templateMode = this.getTemplateMode();
        switch (inlineMode) {
            case NONE: {
                return NoOpInliner.INSTANCE;
            }
            case TEXT: {
                if (templateMode != TemplateMode.TEXT) break;
                return new StandardTextInliner(context.getConfiguration());
            }
            case JAVASCRIPT: {
                if (templateMode != TemplateMode.JAVASCRIPT) break;
                return new StandardJavaScriptInliner(context.getConfiguration());
            }
            case CSS: {
                if (templateMode != TemplateMode.CSS) break;
                return new StandardCSSInliner(context.getConfiguration());
            }
        }
        throw new TemplateProcessingException("Invalid inline mode selected: " + (Object)((Object)inlineMode) + ". Allowed inline modes in template mode " + (Object)((Object)this.getTemplateMode()) + " are: \"" + (Object)((Object)this.getTemplateMode()) + "\" and " + "\"" + (Object)((Object)StandardInlineMode.NONE) + "\"");
    }
}

