/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.BasicSingleConsumerFloatQueue;
import co.paralleluniverse.strands.queues.FloatQueueIterator;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedQueue;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedWordQueue;

public class SingleConsumerLinkedFloatQueue
extends SingleConsumerLinkedWordQueue<Float>
implements BasicSingleConsumerFloatQueue {
    @Override
    public boolean enq(float item) {
        return this.enqRaw(Float.floatToRawIntBits(item));
    }

    @Override
    public boolean enq(Float item) {
        if (item == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        return this.enq(item.floatValue());
    }

    float floatValue(SingleConsumerLinkedQueue.Node<Float> node) {
        return Float.intBitsToFloat(this.rawValue(node));
    }

    @Override
    Float value(SingleConsumerLinkedQueue.Node<Float> node) {
        return Float.valueOf(this.floatValue(node));
    }

    @Override
    public float pollFloat() {
        SingleConsumerLinkedQueue.Node<Float> n = this.pk();
        float val = this.floatValue(n);
        this.deq(n);
        return val;
    }

    @Override
    public FloatQueueIterator iterator() {
        return new FloatLinkedQueueIterator();
    }

    private class FloatLinkedQueueIterator
    extends SingleConsumerLinkedQueue.LinkedQueueIterator
    implements FloatQueueIterator {
        private FloatLinkedQueueIterator() {
            super(SingleConsumerLinkedFloatQueue.this);
        }

        @Override
        public float floatValue() {
            return SingleConsumerLinkedFloatQueue.this.floatValue(this.n);
        }

        @Override
        public float floatNext() {
            this.n = SingleConsumerLinkedFloatQueue.this.succ(this.n);
            return this.floatValue();
        }
    }
}

