/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import com.mongodb.Block;
import com.mongodb.WriteConcern;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.DistinctIterable;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.impl.JsonObjectBsonAdapter;
import io.vertx.ext.mongo.impl.codec.json.JsonObjectCodec;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.codecs.DecoderContext;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class MongoClientImpl
implements MongoClient {
    private static final Logger log = LoggerFactory.getLogger(MongoClientImpl.class);
    private static final UpdateOptions DEFAULT_UPDATE_OPTIONS = new UpdateOptions();
    private static final FindOptions DEFAULT_FIND_OPTIONS = new FindOptions();
    private static final String ID_FIELD = "_id";
    private static final String DS_LOCAL_MAP_NAME = "__vertx.MongoClient.datasources";
    private final Vertx vertx;
    protected com.mongodb.async.client.MongoClient mongo;
    protected final MongoHolder holder;
    protected boolean useObjectId;

    public MongoClientImpl(Vertx vertx, JsonObject config, String dataSourceName) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        Objects.requireNonNull(dataSourceName);
        this.vertx = vertx;
        this.holder = this.lookupHolder(dataSourceName, config);
        this.mongo = this.holder.mongo();
        this.useObjectId = config.getBoolean("useObjectId", Boolean.valueOf(false));
    }

    @Override
    public void close() {
        this.holder.close();
    }

    @Override
    public MongoClient save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.saveWithOptions(collection, document, null, resultHandler);
        return this;
    }

    @Override
    public MongoClient saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(document, "document cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        Object id = document.getValue(ID_FIELD);
        if (id == null) {
            coll.insertOne((Object)document, this.convertCallback(resultHandler, wr -> this.useObjectId ? document.getJsonObject(ID_FIELD).getString("$oid") : document.getString(ID_FIELD)));
        } else {
            JsonObject filter = new JsonObject();
            JsonObject encodedDocument = this.encodeKeyWhenUseObjectId(document);
            filter.put(ID_FIELD, encodedDocument.getValue(ID_FIELD));
            com.mongodb.client.model.UpdateOptions updateOptions = new com.mongodb.client.model.UpdateOptions().upsert(true);
            coll.replaceOne((Bson)this.wrap(filter), (Object)encodedDocument, updateOptions, this.convertCallback(resultHandler, result -> null));
        }
        return this;
    }

    @Override
    public MongoClient insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.insertWithOptions(collection, document, null, resultHandler);
        return this;
    }

    @Override
    public MongoClient insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(document, "document cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        boolean id = document.containsKey(ID_FIELD);
        JsonObject encodedDocument = this.encodeKeyWhenUseObjectId(document);
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        coll.insertOne((Object)encodedDocument, this.convertCallback(resultHandler, wr -> {
            if (id) {
                return null;
            }
            JsonObject decodedDocument = this.decodeKeyWhenUseObjectId(encodedDocument);
            return decodedDocument.getString(ID_FIELD);
        }));
        return this;
    }

    @Override
    @Deprecated
    public MongoClient update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) {
        this.updateWithOptions(collection, query, update, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoClient updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.updateCollectionWithOptions(collection, query, update, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    public MongoClient updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.updateCollectionWithOptions(collection, query, update, options, this.toVoidAsyncResult(resultHandler));
        return this;
    }

    @Override
    public MongoClient updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(update, "update cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(query);
        JsonObjectBsonAdapter bupdate = this.wrap(update);
        if (options.isMulti()) {
            coll.updateMany((Bson)bquery, (Bson)bupdate, MongoClientImpl.mongoUpdateOptions(options), this.toMongoClientUpdateResult(resultHandler));
        } else {
            coll.updateOne((Bson)bquery, (Bson)bupdate, MongoClientImpl.mongoUpdateOptions(options), this.toMongoClientUpdateResult(resultHandler));
        }
        return this;
    }

    @Override
    @Deprecated
    public MongoClient replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) {
        this.replaceWithOptions(collection, query, replace, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoClient replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.replaceDocumentsWithOptions(collection, query, replace, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    public MongoClient replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        return this.replaceDocumentsWithOptions(collection, query, replace, options, this.toVoidAsyncResult(resultHandler));
    }

    @Override
    public MongoClient replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(replace, "update cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        boolean id = query.containsKey(ID_FIELD);
        query = this.encodeKeyWhenUseObjectId(query);
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(query);
        coll.replaceOne((Bson)bquery, (Object)replace, MongoClientImpl.mongoUpdateOptions(options), this.toMongoClientUpdateResult(resultHandler));
        return this;
    }

    @Override
    public MongoClient find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.findWithOptions(collection, query, DEFAULT_FIND_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoClient findBatch(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.findBatchWithOptions(collection, query, DEFAULT_FIND_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoClient findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        FindIterable<JsonObject> view = this.doFind(collection, query, options);
        ArrayList results = new ArrayList();
        view.into(results, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient findBatchWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        FindIterable<JsonObject> view = this.doFind(collection, query, options);
        Block documentBlock = document -> this.wrapCallback(resultHandler).onResult(document, null);
        SingleResultCallback callbackWhenFinished = (result, throwable) -> {
            if (throwable != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)throwable));
            }
        };
        view.forEach(documentBlock, callbackWhenFinished);
        return this;
    }

    @Override
    public MongoClient findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        JsonObjectBsonAdapter bfields = this.wrap(fields);
        this.getCollection(collection).find((Bson)bquery).projection((Bson)bfields).first(this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObjectBsonAdapter bquery = this.wrap(query);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.count((Bson)bquery, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    @Deprecated
    public MongoClient remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.removeWithOptions(collection, query, null, resultHandler);
        return this;
    }

    @Override
    public MongoClient removeDocuments(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.removeDocumentsWithOptions(collection, query, null, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    public MongoClient removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        this.removeDocumentsWithOptions(collection, query, writeOption, this.toVoidAsyncResult(resultHandler));
        return this;
    }

    @Override
    public MongoClient removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(query);
        coll.deleteMany((Bson)bquery, this.toMongoClientDeleteResult(resultHandler));
        return this;
    }

    @Override
    @Deprecated
    public MongoClient removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.removeOneWithOptions(collection, query, null, resultHandler);
        return this;
    }

    @Override
    public MongoClient removeDocument(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.removeDocumentWithOptions(collection, query, null, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    public MongoClient removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        this.removeDocumentWithOptions(collection, query, writeOption, this.toVoidAsyncResult(resultHandler));
        return this;
    }

    @Override
    public MongoClient removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(query);
        coll.deleteOne((Bson)bquery, this.toMongoClientDeleteResult(resultHandler));
        return this;
    }

    @Override
    public MongoClient createCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        this.holder.db.createCollection(collection, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        ArrayList names = new ArrayList();
        Context context = this.vertx.getOrCreateContext();
        this.holder.db.listCollectionNames().into(names, (res, error) -> context.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)names));
            }
        }));
        return this;
    }

    @Override
    public MongoClient dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.drop(this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(commandName, "commandName cannot be null");
        Objects.requireNonNull(command, "command cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObject json = new JsonObject();
        Object commandVal = command.getValue(commandName);
        if (commandVal == null) {
            throw new IllegalArgumentException("commandBody does not contain key for " + commandName);
        }
        json.put(commandName, commandVal);
        command.forEach(entry -> {
            if (!((String)entry.getKey()).equals(commandName)) {
                json.put((String)entry.getKey(), entry.getValue());
            }
        });
        this.holder.db.runCommand((Bson)this.wrap(json), JsonObject.class, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) {
        DistinctIterable distinctValues = this.findDistinctValues(collection, fieldName, resultClassname, resultHandler);
        if (distinctValues != null) {
            ArrayList results = new ArrayList();
            try {
                Context context = this.vertx.getOrCreateContext();
                distinctValues.into(results, (result, throwable) -> context.runOnContext(v -> {
                    if (throwable != null) {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)throwable));
                    } else {
                        resultHandler.handle((Object)Future.succeededFuture((Object)new JsonArray((List)result)));
                    }
                }));
            }
            catch (Exception unhandledEx) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)unhandledEx));
            }
        }
        return this;
    }

    @Override
    public MongoClient distinctBatch(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonObject>> resultHandler) {
        DistinctIterable distinctValues = this.findDistinctValues(collection, fieldName, resultClassname, resultHandler);
        if (distinctValues != null) {
            Context context = this.vertx.getOrCreateContext();
            Block valueBlock = value -> context.runOnContext(v -> {
                HashMap<String, Object> mapValue = new HashMap<String, Object>();
                mapValue.put(fieldName, value);
                resultHandler.handle((Object)Future.succeededFuture((Object)new JsonObject(mapValue)));
            });
            SingleResultCallback callbackWhenFinished = (result, throwable) -> {
                if (throwable != null) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)throwable));
                }
            };
            try {
                distinctValues.forEach(valueBlock, callbackWhenFinished);
            }
            catch (Exception unhandledEx) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)unhandledEx));
            }
        }
        return this;
    }

    private DistinctIterable findDistinctValues(String collection, String fieldName, String resultClassname, Handler resultHandler) {
        Class<?> resultClass;
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(fieldName, "fieldName cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        try {
            resultClass = Class.forName(resultClassname);
        }
        catch (ClassNotFoundException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
            return null;
        }
        MongoCollection<JsonObject> mongoCollection = this.getCollection(collection);
        return mongoCollection.distinct(fieldName, resultClass);
    }

    private JsonObject encodeKeyWhenUseObjectId(JsonObject json) {
        String idString;
        if (this.useObjectId && json.containsKey(ID_FIELD) && json.getValue(ID_FIELD) instanceof String && ObjectId.isValid((String)(idString = json.getString(ID_FIELD)))) {
            json.put(ID_FIELD, new JsonObject().put("$oid", idString));
        }
        return json;
    }

    private JsonObject decodeKeyWhenUseObjectId(JsonObject json) {
        Object idValue;
        if (this.useObjectId && json.containsKey(ID_FIELD) && (idValue = json.getValue(ID_FIELD)) instanceof JsonObject && ((JsonObject)idValue).containsKey("$oid")) {
            json.put(ID_FIELD, json.getJsonObject(ID_FIELD).getString("$oid"));
        }
        return json;
    }

    private <T, R> SingleResultCallback<T> convertCallback(Handler<AsyncResult<R>> resultHandler, Function<T, R> converter) {
        Context context = this.vertx.getOrCreateContext();
        return (result, error) -> context.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(converter.apply(result)));
            }
        });
    }

    private <T> Handler<AsyncResult<T>> toVoidAsyncResult(Handler<AsyncResult<Void>> resultHandler) {
        return result -> {
            if (result.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture(null));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)result.cause()));
            }
        };
    }

    private SingleResultCallback<UpdateResult> toMongoClientUpdateResult(Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        return this.convertCallback(resultHandler, result -> {
            if (result.wasAcknowledged()) {
                return this.convertToMongoClientUpdateResult(result.getMatchedCount(), result.getUpsertedId(), result.getModifiedCount());
            }
            return null;
        });
    }

    private SingleResultCallback<DeleteResult> toMongoClientDeleteResult(Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        return this.convertCallback(resultHandler, result -> {
            if (result.wasAcknowledged()) {
                return new MongoClientDeleteResult(result.getDeletedCount());
            }
            return null;
        });
    }

    private <T> SingleResultCallback<T> wrapCallback(Handler<AsyncResult<T>> resultHandler) {
        Context context = this.vertx.getOrCreateContext();
        return (result, error) -> context.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)result));
            }
        });
    }

    private FindIterable<JsonObject> doFind(String collection, JsonObject query, FindOptions options) {
        return this.doFind(collection, null, query, options);
    }

    private FindIterable<JsonObject> doFind(String collection, WriteOption writeOption, JsonObject query, FindOptions options) {
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(query);
        FindIterable find = coll.find((Bson)bquery, JsonObject.class);
        if (options.getLimit() != -1) {
            find.limit(options.getLimit());
        }
        if (options.getSkip() > 0) {
            find.skip(options.getSkip());
        }
        if (options.getSort() != null) {
            find.sort((Bson)this.wrap(options.getSort()));
        }
        if (options.getFields() != null) {
            find.projection((Bson)this.wrap(options.getFields()));
        }
        return find;
    }

    private MongoCollection<JsonObject> getCollection(String name) {
        return this.getCollection(name, null);
    }

    private MongoCollection<JsonObject> getCollection(String name, WriteOption writeOption) {
        MongoCollection coll = this.holder.db.getCollection(name, JsonObject.class);
        if (coll != null && writeOption != null) {
            coll = coll.withWriteConcern(WriteConcern.valueOf((String)writeOption.name()));
        }
        return coll;
    }

    private static com.mongodb.client.model.UpdateOptions mongoUpdateOptions(UpdateOptions options) {
        return new com.mongodb.client.model.UpdateOptions().upsert(options.isUpsert());
    }

    private JsonObjectBsonAdapter wrap(JsonObject jsonObject) {
        return jsonObject == null ? null : new JsonObjectBsonAdapter(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(LocalMap<String, MongoHolder> map, String dataSourceName) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            map.remove((Object)dataSourceName);
            if (map.isEmpty()) {
                map.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoHolder lookupHolder(String datasourceName, JsonObject config) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            LocalMap map = this.vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
            MongoHolder theHolder = (MongoHolder)map.get((Object)datasourceName);
            if (theHolder == null) {
                theHolder = new MongoHolder(config, () -> this.removeFromMap((LocalMap<String, MongoHolder>)map, datasourceName));
                map.put((Object)datasourceName, (Object)theHolder);
            } else {
                theHolder.incRefCount();
            }
            return theHolder;
        }
    }

    private MongoClientUpdateResult convertToMongoClientUpdateResult(long docMatched, BsonValue upsertId, long docModified) {
        JsonObject jsonUpsertId;
        if (upsertId != null) {
            JsonObjectCodec jsonObjectCodec = new JsonObjectCodec(new JsonObject());
            BsonDocument upsertIdDocument = new BsonDocument();
            upsertIdDocument.append(ID_FIELD, upsertId);
            BsonDocumentReader bsonDocumentReader = new BsonDocumentReader(upsertIdDocument);
            jsonUpsertId = (JsonObject)jsonObjectCodec.decode((BsonReader)bsonDocumentReader, DecoderContext.builder().build());
        } else {
            jsonUpsertId = null;
        }
        return new MongoClientUpdateResult(docMatched, jsonUpsertId, docModified);
    }

    private static class MongoHolder
    implements Shareable {
        com.mongodb.async.client.MongoClient mongo;
        MongoDatabase db;
        JsonObject config;
        Runnable closeRunner;
        int refCount = 1;

        public MongoHolder(JsonObject config, Runnable closeRunner) {
            this.config = config;
            this.closeRunner = closeRunner;
        }

        synchronized com.mongodb.async.client.MongoClient mongo() {
            if (this.mongo == null) {
                MongoClientOptionsParser parser = new MongoClientOptionsParser(this.config);
                this.mongo = MongoClients.create((MongoClientSettings)parser.settings());
                this.db = this.mongo.getDatabase(parser.database());
            }
            return this.mongo;
        }

        synchronized void incRefCount() {
            ++this.refCount;
        }

        synchronized void close() {
            if (--this.refCount == 0) {
                if (this.mongo != null) {
                    this.mongo.close();
                }
                if (this.closeRunner != null) {
                    this.closeRunner.run();
                }
            }
        }
    }
}

