/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.psi.KtExpression;

public class DefaultAccessTranslator
implements AccessTranslator {
    private final KtExpression expression;
    private final TranslationContext context;

    public DefaultAccessTranslator(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/DefaultAccessTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/DefaultAccessTranslator", "<init>"));
        }
        this.expression = expression;
        this.context = context;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = Translation.translateAsExpression(this.expression, this.context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/DefaultAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        if (setTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setTo", "org/jetbrains/kotlin/js/translate/reference/DefaultAccessTranslator", "translateAsSet"));
        }
        throw new UnsupportedOperationException("This method is not meant to be supported in in DefaultAccessTranslator");
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        throw new UnsupportedOperationException("This method is not meant to be supported in in DefaultAccessTranslator");
    }
}

