/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.EmptyStatement;
import java.io.InputStream;
import java.util.Properties;

public final class BuildInfoProvider {
    private BuildInfoProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildInfo getBuildInfo() {
        InputStream inRuntimeProperties = BuildInfoProvider.class.getClassLoader().getResourceAsStream("hazelcast-runtime.properties");
        Properties runtimeProperties = new Properties();
        try {
            if (inRuntimeProperties != null) {
                runtimeProperties.load(inRuntimeProperties);
            }
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        finally {
            IOUtil.closeResource(inRuntimeProperties);
        }
        String version = runtimeProperties.getProperty("hazelcast.version");
        String distribution = runtimeProperties.getProperty("hazelcast.distribution");
        String revision = runtimeProperties.getProperty("hazelcast.git.revision", "");
        if (!revision.isEmpty() && revision.equals("${git.commit.id.abbrev}")) {
            revision = "";
        }
        boolean enterprise = !"Hazelcast".equals(distribution);
        Integer hazelcastBuild = Integer.getInteger("hazelcast.build", -1);
        String build = hazelcastBuild == -1 ? runtimeProperties.getProperty("hazelcast.build") : String.valueOf(hazelcastBuild);
        int buildNumber = Integer.parseInt(build);
        String sv = runtimeProperties.getProperty("hazelcast.serialization.version");
        byte serialVersion = Byte.parseByte(sv);
        return new BuildInfo(version, build, revision, buildNumber, enterprise, serialVersion);
    }
}

