/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl.operations;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.IsStillRunningService;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import java.io.IOException;

public class TraceableIsStillExecutingOperation
extends AbstractOperation
implements UrgentSystemOperation,
ReadonlyOperation {
    private String serviceName;
    private Object identifier;

    TraceableIsStillExecutingOperation() {
    }

    public TraceableIsStillExecutingOperation(String serviceName, Object identifier) {
        this.serviceName = serviceName;
        this.identifier = identifier;
    }

    @Override
    public void run() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        OperationServiceImpl operationService = (OperationServiceImpl)nodeEngine.getOperationService();
        IsStillRunningService isStillRunningService = operationService.getIsStillRunningService();
        boolean executing = isStillRunningService.isOperationExecuting(this.getCallerAddress(), this.getCallerUuid(), this.serviceName, this.identifier);
        this.getOperationResponseHandler().sendResponse(this, executing);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.serviceName = in.readUTF();
        this.identifier = in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.serviceName);
        out.writeObject(this.identifier);
    }
}

