/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.lang.groovy.GroovyVerticle;
import io.vertx.lang.groovy.ScriptVerticle;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.control.CompilerConfiguration;

public class GroovyVerticleFactory
implements VerticleFactory {
    private static final String CONFIGURATION_PROPERTY = "vertx.groovy.compilerConfiguration";
    private static Logger log = LoggerFactory.getLogger(GroovyVerticleFactory.class);
    private Vertx vertx;

    public void init(Vertx vertx) {
        this.vertx = vertx;
    }

    public String prefix() {
        return "groovy";
    }

    public boolean blockingCreate() {
        return true;
    }

    public Verticle createVerticle(String verticleName, ClassLoader classLoader) throws Exception {
        Object verticle;
        Object instance;
        verticleName = VerticleFactory.removePrefix((String)verticleName);
        CompilerConfiguration compilerConfig = this.createCompilerConfiguration(classLoader);
        if (verticleName.endsWith(".groovy")) {
            URL url = classLoader.getResource(verticleName);
            if (url == null) {
                File f = new File(verticleName);
                if (!f.isAbsolute()) {
                    f = new File(System.getProperty("user.dir"), verticleName);
                }
                if (f.exists() && f.isFile()) {
                    url = f.toURI().toURL();
                }
            }
            if (url == null) {
                throw new IllegalStateException("Cannot find verticle script: " + verticleName + " on classpath");
            }
            GroovyClassLoader gcl = new GroovyClassLoader(classLoader, compilerConfig);
            GroovyCodeSource gcs = new GroovyCodeSource(url);
            Class clazz = gcl.parseClass(gcs);
            instance = clazz.newInstance();
        } else {
            Class<?> clazz = classLoader.loadClass(verticleName);
            instance = clazz.newInstance();
        }
        if (instance instanceof GroovyVerticle) {
            verticle = ((GroovyVerticle)instance).asJavaVerticle();
        } else if (instance instanceof Script) {
            verticle = new ScriptVerticle((Script)instance);
        } else if (instance instanceof Verticle) {
            verticle = (Verticle)instance;
        } else {
            throw new Exception("Class " + instance.getClass().getName() + " is not a Verticle");
        }
        return verticle;
    }

    public void close() {
        this.vertx = null;
    }

    private CompilerConfiguration createCompilerConfiguration(ClassLoader cl) {
        Object result;
        Properties properties;
        Closure customizer;
        block8: {
            customizer = null;
            properties = new Properties();
            URL url = this.findConfigurationResource(cl);
            if (url != null) {
                log.trace((Object)"Configuring groovy compiler with ${url}");
                try {
                    if (url.getFile().toLowerCase().endsWith(".groovy")) {
                        ConfigSlurper slurper = new ConfigSlurper();
                        slurper.setClassLoader(new GroovyClassLoader(cl));
                        ConfigObject cObject = slurper.parse(url);
                        Object c = cObject.remove((Object)"customizer");
                        if (c instanceof Closure) {
                            customizer = (Closure)c;
                        }
                        properties.putAll((Map<?, ?>)cObject.toProperties());
                        break block8;
                    }
                    InputStream stream = url.openStream();
                    properties.load(stream);
                }
                catch (Exception e) {
                    log.error((Object)"Error loading Groovy CompilerConfiguration properties from $url", (Throwable)e);
                }
            } else {
                log.trace((Object)"No groovy configuration file found.");
            }
        }
        CompilerConfiguration compilerCfg = new CompilerConfiguration(CompilerConfiguration.DEFAULT);
        if (properties.size() != 0) {
            compilerCfg.configure(properties);
        }
        if (customizer != null && (result = customizer.call((Object)compilerCfg)) instanceof CompilerConfiguration) {
            compilerCfg = (CompilerConfiguration)result;
        }
        return compilerCfg;
    }

    private URL findConfigurationResource(ClassLoader cl) {
        try {
            String prop = System.getProperty(CONFIGURATION_PROPERTY);
            if (prop != null) {
                return cl.getResource(prop);
            }
        }
        catch (SecurityException prop) {
            // empty catch block
        }
        URL url = cl.getResource("compilerConfiguration.groovy");
        if (url == null) {
            url = cl.getResource("compilerConfiguration.properties");
        }
        return url;
    }
}

