/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.ServiceHelper;
import io.vertx.core.spi.FutureFactory;
import java.util.function.Function;

@VertxGen
public interface Future<T>
extends AsyncResult<T> {
    public static final FutureFactory factory = ServiceHelper.loadFactory(FutureFactory.class);

    public static <T> Future<T> future() {
        return factory.future();
    }

    public static <T> Future<T> succeededFuture() {
        return factory.succeededFuture();
    }

    public static <T> Future<T> succeededFuture(T result) {
        return factory.succeededFuture(result);
    }

    public static <T> Future<T> failedFuture(Throwable t) {
        return factory.failedFuture(t);
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        return factory.failureFuture(failureMessage);
    }

    public boolean isComplete();

    @Fluent
    public Future<T> setHandler(Handler<AsyncResult<T>> var1);

    public void complete(T var1);

    public void complete();

    public void fail(Throwable var1);

    public void fail(String var1);

    @Override
    public T result();

    @Override
    public Throwable cause();

    @Override
    public boolean succeeded();

    @Override
    public boolean failed();

    default public <U> Future<U> compose(Handler<T> handler, Future<U> next) {
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                try {
                    handler.handle(ar.result());
                }
                catch (Throwable err) {
                    if (next.isComplete()) {
                        throw err;
                    }
                    next.fail(err);
                }
            } else {
                next.fail(ar.cause());
            }
        });
        return next;
    }

    default public <U> Future<U> compose(Function<T, Future<U>> mapper) {
        Future ret = Future.future();
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                Future apply;
                try {
                    apply = (Future)mapper.apply(ar.result());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                apply.setHandler(ret.completer());
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret;
    }

    @Override
    default public <U> Future<U> map(Function<T, U> mapper) {
        Future ret = Future.future();
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                Object mapped;
                try {
                    mapped = mapper.apply(ar.result());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                ret.complete(mapped);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret;
    }

    @Override
    default public <V> Future<V> map(V value) {
        Future ret = Future.future();
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                ret.complete(value);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret;
    }

    @CacheReturn
    default public Handler<AsyncResult<T>> completer() {
        return ar -> {
            if (ar.succeeded()) {
                this.complete(ar.result());
            } else {
                this.fail(ar.cause());
            }
        };
    }
}

