/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Map;

public final class HttpUtils {
    private static final CustomCompressor compressor = new CustomCompressor();

    private HttpUtils() {
    }

    static String parsePath(String uri) {
        int i;
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }

    static String parseQuery(String uri) {
        int i = uri.indexOf(63);
        if (i == -1) {
            return null;
        }
        return uri.substring(i + 1, uri.length());
    }

    static String absoluteURI(String serverOrigin, HttpServerRequest req) throws URISyntaxException {
        String host;
        URI uri = new URI(req.uri());
        String scheme = uri.getScheme();
        String absoluteURI = scheme != null && (scheme.equals("http") || scheme.equals("https")) ? uri.toString() : ((host = req.host()) != null ? req.scheme() + "://" + host + uri : serverOrigin + uri);
        return absoluteURI;
    }

    static MultiMap params(String uri) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        Map prms = queryStringDecoder.parameters();
        CaseInsensitiveHeaders params = new CaseInsensitiveHeaders();
        if (!prms.isEmpty()) {
            for (Map.Entry entry : prms.entrySet()) {
                params.add((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return params;
    }

    public static void fromVertxInitialSettings(boolean server, Http2Settings vertxSettings, io.netty.handler.codec.http2.Http2Settings nettySettings) {
        if (vertxSettings != null) {
            Map<Integer, Long> extraSettings;
            if (!server && !vertxSettings.isPushEnabled()) {
                nettySettings.pushEnabled(vertxSettings.isPushEnabled());
            }
            if (vertxSettings.getHeaderTableSize() != 4096L) {
                nettySettings.put('\u0001', Long.valueOf(vertxSettings.getHeaderTableSize()));
            }
            if (vertxSettings.getInitialWindowSize() != 65535) {
                nettySettings.initialWindowSize(vertxSettings.getInitialWindowSize());
            }
            if (vertxSettings.getMaxConcurrentStreams() != 0xFFFFFFFFL) {
                nettySettings.maxConcurrentStreams(vertxSettings.getMaxConcurrentStreams());
            }
            if (vertxSettings.getMaxFrameSize() != 16384) {
                nettySettings.maxFrameSize(vertxSettings.getMaxFrameSize());
            }
            if (vertxSettings.getMaxHeaderListSize() != Integer.MAX_VALUE) {
                nettySettings.maxHeaderListSize(vertxSettings.getMaxHeaderListSize());
            }
            if ((extraSettings = vertxSettings.getExtraSettings()) != null) {
                extraSettings.forEach((code, setting) -> nettySettings.put((char)code.intValue(), setting));
            }
        }
    }

    public static io.netty.handler.codec.http2.Http2Settings fromVertxSettings(Http2Settings settings) {
        io.netty.handler.codec.http2.Http2Settings converted = new io.netty.handler.codec.http2.Http2Settings();
        converted.pushEnabled(settings.isPushEnabled());
        converted.maxFrameSize(settings.getMaxFrameSize());
        converted.initialWindowSize(settings.getInitialWindowSize());
        converted.headerTableSize(settings.getHeaderTableSize());
        converted.maxConcurrentStreams(settings.getMaxConcurrentStreams());
        converted.maxHeaderListSize(settings.getMaxHeaderListSize());
        if (settings.getExtraSettings() != null) {
            settings.getExtraSettings().forEach((key, value) -> converted.put((char)key.intValue(), value));
        }
        return converted;
    }

    public static Http2Settings toVertxSettings(io.netty.handler.codec.http2.Http2Settings settings) {
        Long headerTableSize;
        Integer initialWindowSize;
        Integer maxFrameSize;
        Long maxHeaderListSize;
        Long maxConcurrentStreams;
        Http2Settings converted = new Http2Settings();
        Boolean pushEnabled = settings.pushEnabled();
        if (pushEnabled != null) {
            converted.setPushEnabled(pushEnabled);
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            converted.setMaxConcurrentStreams(maxConcurrentStreams);
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            converted.setMaxHeaderListSize(maxHeaderListSize);
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            converted.setMaxFrameSize(maxFrameSize);
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            converted.setInitialWindowSize(initialWindowSize);
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            converted.setHeaderTableSize(headerTableSize);
        }
        settings.forEach((key, value) -> {
            if (key.charValue() > '\u0006') {
                converted.set(key.charValue(), (long)value);
            }
        });
        return converted;
    }

    static io.netty.handler.codec.http2.Http2Settings decodeSettings(String base64Settings) {
        try {
            io.netty.handler.codec.http2.Http2Settings settings = new io.netty.handler.codec.http2.Http2Settings();
            Buffer buffer = Buffer.buffer(Base64.getUrlDecoder().decode(base64Settings));
            int len = buffer.length();
            for (int pos = 0; pos < len; pos += 4) {
                int i = buffer.getUnsignedShort(pos);
                long j = buffer.getUnsignedInt(pos += 2);
                settings.put((char)i, Long.valueOf(j));
            }
            return settings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String determineContentEncoding(Http2Headers headers) {
        ZlibWrapper wrapper;
        String acceptEncoding;
        String string = acceptEncoding = headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
        if (acceptEncoding != null && (wrapper = compressor.determineWrapper(acceptEncoding)) != null) {
            switch (wrapper) {
                case GZIP: {
                    return "gzip";
                }
                case ZLIB: {
                    return "deflate";
                }
            }
        }
        return null;
    }

    static io.netty.handler.codec.http.HttpMethod toNettyHttpMethod(HttpMethod method, String rawMethod) {
        switch (method) {
            case CONNECT: {
                return io.netty.handler.codec.http.HttpMethod.CONNECT;
            }
            case GET: {
                return io.netty.handler.codec.http.HttpMethod.GET;
            }
            case PUT: {
                return io.netty.handler.codec.http.HttpMethod.PUT;
            }
            case POST: {
                return io.netty.handler.codec.http.HttpMethod.POST;
            }
            case DELETE: {
                return io.netty.handler.codec.http.HttpMethod.DELETE;
            }
            case HEAD: {
                return io.netty.handler.codec.http.HttpMethod.HEAD;
            }
            case OPTIONS: {
                return io.netty.handler.codec.http.HttpMethod.OPTIONS;
            }
            case TRACE: {
                return io.netty.handler.codec.http.HttpMethod.TRACE;
            }
            case PATCH: {
                return io.netty.handler.codec.http.HttpMethod.PATCH;
            }
        }
        return io.netty.handler.codec.http.HttpMethod.valueOf((String)rawMethod);
    }

    static io.netty.handler.codec.http.HttpVersion toNettyHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_0;
            }
            case HTTP_1_1: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_1;
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP version: " + (Object)((Object)version));
    }

    static HttpMethod toVertxMethod(String method) {
        try {
            return HttpMethod.valueOf(method);
        }
        catch (IllegalArgumentException e) {
            return HttpMethod.OTHER;
        }
    }

    private static class CustomCompressor
    extends HttpContentCompressor {
        private CustomCompressor() {
        }

        public ZlibWrapper determineWrapper(String acceptEncoding) {
            return super.determineWrapper(acceptEncoding);
        }
    }
}

