/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.HostsFileParser;
import io.netty.resolver.NameResolver;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.launcher.commands.ExecUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddressResolver {
    private static final int DEFAULT_NDOTS;
    private static final Pattern NDOTS_OPTIONS_PATTERN;
    private static final String DISABLE_DNS_RESOLVER_PROP_NAME = "vertx.disableDnsResolver";
    private static final boolean DISABLE_DNS_RESOLVER;
    private final Vertx vertx;
    private final AddressResolverGroup<InetSocketAddress> resolverGroup;

    public AddressResolver(final VertxImpl vertx, final AddressResolverOptions options) {
        if (!DISABLE_DNS_RESOLVER) {
            Map entries;
            DnsServerAddresses nameServerAddresses;
            List<String> dnsServers = options.getServers();
            if (dnsServers != null && dnsServers.size() > 0) {
                ArrayList<InetSocketAddress> serverList = new ArrayList<InetSocketAddress>();
                for (String dnsServer : dnsServers) {
                    int port;
                    String ipAddress;
                    int sep = dnsServer.indexOf(58);
                    if (sep != -1) {
                        ipAddress = dnsServer.substring(0, sep);
                        port = Integer.parseInt(dnsServer.substring(sep + 1));
                    } else {
                        ipAddress = dnsServer;
                        port = 53;
                    }
                    try {
                        serverList.add(new InetSocketAddress(InetAddress.getByAddress(NetUtil.createByteArrayFromIpAddressString((String)ipAddress)), port));
                    }
                    catch (UnknownHostException e) {
                        throw new VertxException(e);
                    }
                }
                nameServerAddresses = DnsServerAddresses.sequential(serverList);
            } else {
                nameServerAddresses = DnsServerAddresses.defaultAddresses();
            }
            if (options.getHostsPath() != null) {
                File file = vertx.resolveFile(options.getHostsPath()).getAbsoluteFile();
                try {
                    if (!file.exists() || !file.isFile()) {
                        throw new IOException();
                    }
                    entries = HostsFileParser.parse((File)file);
                }
                catch (IOException e) {
                    throw new VertxException("Cannot read hosts file " + file.getAbsolutePath());
                }
            } else if (options.getHostsValue() != null) {
                try {
                    entries = HostsFileParser.parse((Reader)new StringReader(options.getHostsValue().toString()));
                }
                catch (IOException e) {
                    throw new VertxException("Cannot read hosts config ", e);
                }
            } else {
                entries = HostsFileParser.parseSilently();
            }
            this.resolverGroup = new AsyncCloseableResolverGroup(){
                private final List<ResolverRegistration> resolvers = Collections.synchronizedList(new ArrayList());

                protected io.netty.resolver.AddressResolver<InetSocketAddress> newResolver(final EventExecutor executor) throws Exception {
                    DnsAddressResolverGroup group = new DnsAddressResolverGroup(NioDatagramChannel.class, nameServerAddresses){

                        protected NameResolver<InetAddress> newNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsServerAddresses nameServerAddresses) throws Exception {
                            DnsNameResolverBuilder builder = new DnsNameResolverBuilder((EventLoop)executor);
                            builder.hostsFileEntriesResolver(inetHost -> {
                                InetAddress addr = (InetAddress)entries.get(inetHost);
                                if (addr == null) {
                                    addr = (InetAddress)entries.get(inetHost.toLowerCase(Locale.ENGLISH));
                                }
                                return addr;
                            });
                            builder.channelType(NioDatagramChannel.class);
                            builder.nameServerAddresses(nameServerAddresses);
                            builder.optResourceEnabled(options.isOptResourceEnabled());
                            builder.ttl(options.getCacheMinTimeToLive(), options.getCacheMaxTimeToLive());
                            builder.negativeTtl(options.getCacheNegativeTimeToLive());
                            builder.queryTimeoutMillis(options.getQueryTimeout());
                            builder.maxQueriesPerResolve(options.getMaxQueries());
                            builder.recursionDesired(options.getRdFlag());
                            if (options.getSearchDomains() != null) {
                                builder.searchDomains(options.getSearchDomains());
                                int ndots = options.getNdots();
                                if (ndots == -1) {
                                    ndots = DEFAULT_NDOTS;
                                }
                                builder.ndots(ndots);
                            }
                            return builder.build();
                        }
                    };
                    io.netty.resolver.AddressResolver resolver = group.getResolver(executor);
                    this.resolvers.add(new ResolverRegistration((io.netty.resolver.AddressResolver<InetSocketAddress>)resolver, (EventLoop)executor));
                    return resolver;
                }

                @Override
                void close(Handler<Void> doneHandler) {
                    ContextImpl context = vertx.getOrCreateContext();
                    ResolverRegistration[] registrations = this.resolvers.toArray(new ResolverRegistration[this.resolvers.size()]);
                    if (registrations.length == 0) {
                        context.runOnContext(doneHandler);
                        return;
                    }
                    AtomicInteger count = new AtomicInteger(registrations.length);
                    for (ResolverRegistration registration : registrations) {
                        Runnable task = () -> {
                            registration.resolver.close();
                            if (count.decrementAndGet() == 0) {
                                context.runOnContext(doneHandler);
                            }
                        };
                        if (registration.executor.inEventLoop()) {
                            task.run();
                            continue;
                        }
                        registration.executor.execute(task);
                    }
                }
            };
        } else {
            this.resolverGroup = DefaultAddressResolverGroup.INSTANCE;
        }
        this.vertx = vertx;
    }

    public void resolveHostname(String hostname, Handler<AsyncResult<InetAddress>> resultHandler) {
        ContextInternal callback = (ContextInternal)this.vertx.getOrCreateContext();
        io.netty.resolver.AddressResolver resolver = this.resolverGroup.getResolver((EventExecutor)callback.nettyEventLoop());
        io.netty.util.concurrent.Future fut = resolver.resolve((SocketAddress)InetSocketAddress.createUnresolved(hostname, 0));
        fut.addListener(a -> callback.runOnContext(v -> {
            if (a.isSuccess()) {
                InetSocketAddress address = (InetSocketAddress)fut.getNow();
                resultHandler.handle(Future.succeededFuture(address.getAddress()));
            } else {
                resultHandler.handle(Future.failedFuture(a.cause()));
            }
        }));
    }

    AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup() {
        return this.resolverGroup;
    }

    public void close(Handler<Void> doneHandler) {
        if (this.resolverGroup instanceof AsyncCloseableResolverGroup) {
            ((AsyncCloseableResolverGroup)this.resolverGroup).close(doneHandler);
        } else {
            this.resolverGroup.close();
            doneHandler.handle(null);
        }
    }

    public static int parseNdotsOptionFromResolvConf(String s) {
        int ndots = -1;
        Matcher matcher = NDOTS_OPTIONS_PATTERN.matcher(s);
        while (matcher.find()) {
            ndots = Integer.parseInt(matcher.group(1));
        }
        return ndots;
    }

    static {
        File f;
        NDOTS_OPTIONS_PATTERN = Pattern.compile("^[ \\t\\f]*options[ \\t\\f]+ndots:[ \\t\\f]*(\\d)+(?=$|\\s)", 8);
        DISABLE_DNS_RESOLVER = Boolean.getBoolean(DISABLE_DNS_RESOLVER_PROP_NAME);
        int ndots = 1;
        if (ExecUtils.isLinux() && (f = new File("/etc/resolv.conf")).exists() && f.isFile()) {
            try {
                String conf = new String(Files.readAllBytes(f.toPath()));
                int ndotsOption = AddressResolver.parseNdotsOptionFromResolvConf(conf);
                if (ndotsOption != -1) {
                    ndots = ndotsOption;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        DEFAULT_NDOTS = ndots;
    }

    private static abstract class AsyncCloseableResolverGroup
    extends AddressResolverGroup<InetSocketAddress> {
        private AsyncCloseableResolverGroup() {
        }

        abstract void close(Handler<Void> var1);
    }

    private static class ResolverRegistration {
        private final io.netty.resolver.AddressResolver<InetSocketAddress> resolver;
        private final EventLoop executor;

        ResolverRegistration(io.netty.resolver.AddressResolver<InetSocketAddress> resolver, EventLoop executor) {
            this.resolver = resolver;
            this.executor = executor;
        }
    }
}

