/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.kotlin;

import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptNameUtil;
import org.jetbrains.kotlin.script.ScriptParameter;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/vertx/lang/kotlin/VerticleScriptDefinition;", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "()V", "CONTEXT_NAME", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "VERTX_NAME", "getScriptName", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "getScriptParameters", "", "Lorg/jetbrains/kotlin/script/ScriptParameter;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "isScript", "", "file", "Lcom/intellij/psi/PsiFile;", "vertx-lang-kotlin-compiler"})
public final class VerticleScriptDefinition
implements KotlinScriptDefinition {
    private static final Name VERTX_NAME;
    private static final Name CONTEXT_NAME;
    public static final VerticleScriptDefinition INSTANCE;

    public boolean isScript(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)PathUtil.getFileExtension((String)file.getName()), (Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX);
    }

    @NotNull
    public List<ScriptParameter> getScriptParameters(@NotNull ScriptDescriptor scriptDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)scriptDescriptor, (String)"scriptDescriptor");
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)scriptDescriptor));
        ClassId classId = ClassId.topLevel((FqName)FqName.fromSegments((List)CollectionsKt.listOf((Object[])new String[]{"io", "vertx", "core", "Vertx"})));
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(FqName.\u2026ertx\", \"core\", \"Vertx\")))");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)moduleDescriptor, (ClassId)classId);
        if (classDescriptor == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ClassDescriptor vertxClassDesc = classDescriptor;
        ModuleDescriptor moduleDescriptor2 = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)scriptDescriptor));
        ClassId classId2 = ClassId.topLevel((FqName)FqName.fromSegments((List)CollectionsKt.listOf((Object[])new String[]{"io", "vertx", "core", "Context"})));
        Intrinsics.checkExpressionValueIsNotNull((Object)classId2, (String)"ClassId.topLevel(FqName.\u2026tx\", \"core\", \"Context\")))");
        ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)moduleDescriptor2, (ClassId)classId2);
        if (classDescriptor2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ClassDescriptor contextClassDesc = classDescriptor2;
        Object[] objectArray = new ScriptParameter[2];
        Name name = VERTX_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"VERTX_NAME");
        KotlinType kotlinType = vertxClassDesc.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"vertxClassDesc.defaultType");
        objectArray[0] = new ScriptParameter(name, kotlinType);
        Name name2 = CONTEXT_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"CONTEXT_NAME");
        KotlinType kotlinType2 = contextClassDesc.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"contextClassDesc.defaultType");
        objectArray[1] = new ScriptParameter(name2, kotlinType2);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Name getScriptName(@NotNull KtScript script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Name name = ScriptNameUtil.fileNameWithExtensionStripped((KtScript)script, (String)KotlinParserDefinition.STD_SCRIPT_EXT);
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"ScriptNameUtil.fileNameW\u2026efinition.STD_SCRIPT_EXT)");
        return name;
    }

    private VerticleScriptDefinition() {
        INSTANCE = this;
        VERTX_NAME = Name.identifier((String)"vertx");
        CONTEXT_NAME = Name.identifier((String)"context");
    }

    static {
        new VerticleScriptDefinition();
    }
}

