/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.kotlin;

import io.vertx.codetrans.CodeTranslator;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.lang.kotlin.KotlinLang;
import io.vertx.docgen.Coordinate;
import io.vertx.docgen.DocGenerator;
import io.vertx.docgen.JavaDocGenerator;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class KotlinDocGenerator
implements DocGenerator {
    private JavaDocGenerator javaGen = new JavaDocGenerator();
    private CodeTranslator translator;

    public void init(ProcessingEnvironment processingEnv) {
        this.translator = new CodeTranslator(processingEnv);
        this.javaGen.init(processingEnv);
    }

    public String getName() {
        return "kotlin";
    }

    public String renderSource(ExecutableElement elt, String source) {
        KotlinLang lang = new KotlinLang();
        try {
            return this.translator.translate(elt, (Lang)lang);
        }
        catch (Exception e) {
            System.out.println("Cannot generate " + elt.getEnclosingElement().getSimpleName() + "#" + elt.getSimpleName() + " : " + e.getMessage());
            return "Code not translatable";
        }
    }

    public String resolveTypeLink(TypeElement elt, Coordinate coordinate) {
        return this.javaGen.resolveTypeLink(elt, coordinate);
    }

    public String resolveConstructorLink(ExecutableElement elt, Coordinate coordinate) {
        return this.javaGen.resolveConstructorLink(elt, coordinate);
    }

    public String resolveMethodLink(ExecutableElement elt, Coordinate coordinate) {
        return this.javaGen.resolveMethodLink(elt, coordinate);
    }

    public String resolveLabel(Element elt, String defaultLabel) {
        return this.javaGen.resolveLabel(elt, defaultLabel);
    }

    public String resolveFieldLink(VariableElement elt, Coordinate coordinate) {
        return this.javaGen.resolveFieldLink(elt, coordinate);
    }
}

