/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.spinning;

import com.hazelcast.internal.networking.IOOutOfMemoryHandler;
import com.hazelcast.internal.networking.IOThreadingModel;
import com.hazelcast.internal.networking.SocketConnection;
import com.hazelcast.internal.networking.SocketReader;
import com.hazelcast.internal.networking.SocketReaderInitializer;
import com.hazelcast.internal.networking.SocketWriter;
import com.hazelcast.internal.networking.SocketWriterInitializer;
import com.hazelcast.internal.networking.spinning.SpinningInputThread;
import com.hazelcast.internal.networking.spinning.SpinningOutputThread;
import com.hazelcast.internal.networking.spinning.SpinningSocketReader;
import com.hazelcast.internal.networking.spinning.SpinningSocketWriter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;

public class SpinningIOThreadingModel
implements IOThreadingModel {
    private final ILogger logger;
    private final LoggingService loggingService;
    private final SpinningInputThread inputThread;
    private final SpinningOutputThread outThread;
    private final SocketWriterInitializer socketWriterInitializer;
    private final SocketReaderInitializer socketReaderInitializer;
    private final IOOutOfMemoryHandler oomeHandler;

    public SpinningIOThreadingModel(LoggingService loggingService, IOOutOfMemoryHandler oomeHandler, SocketWriterInitializer socketWriterInitializer, SocketReaderInitializer socketReaderInitializer, String hzName) {
        this.logger = loggingService.getLogger(SpinningIOThreadingModel.class);
        this.loggingService = loggingService;
        this.oomeHandler = oomeHandler;
        this.inputThread = new SpinningInputThread(hzName);
        this.outThread = new SpinningOutputThread(hzName);
        this.socketWriterInitializer = socketWriterInitializer;
        this.socketReaderInitializer = socketReaderInitializer;
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public SocketWriter newSocketWriter(SocketConnection connection) {
        ILogger logger = this.loggingService.getLogger(SpinningSocketWriter.class);
        return new SpinningSocketWriter(connection, logger, this.oomeHandler, this.socketWriterInitializer);
    }

    @Override
    public SocketReader newSocketReader(SocketConnection connection) {
        ILogger logger = this.loggingService.getLogger(SpinningSocketReader.class);
        return new SpinningSocketReader(connection, logger, this.oomeHandler, this.socketReaderInitializer);
    }

    @Override
    public void onConnectionAdded(SocketConnection connection) {
        this.inputThread.addConnection(connection);
        this.outThread.addConnection(connection);
    }

    @Override
    public void onConnectionRemoved(SocketConnection connection) {
        this.inputThread.removeConnection(connection);
        this.outThread.removeConnection(connection);
    }

    @Override
    public void start() {
        this.logger.info("TcpIpConnectionManager configured with Spinning IO-threading model: 1 input thread and 1 output thread");
        this.inputThread.start();
        this.outThread.start();
    }

    @Override
    public void shutdown() {
        this.inputThread.shutdown();
        this.outThread.shutdown();
    }
}

