/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.proton.ProtonServerOptionsConverter;
import java.util.Map;
import java.util.Set;

@DataObject(generateConverter=true, publicConverter=false)
public class ProtonServerOptions
extends NetServerOptions {
    private int heartbeat;
    private int maxFrameSize;

    public ProtonServerOptions() {
    }

    public ProtonServerOptions(ProtonServerOptions other) {
        super((NetServerOptions)other);
        this.heartbeat = other.heartbeat;
        this.maxFrameSize = other.maxFrameSize;
    }

    public ProtonServerOptions(JsonObject json) {
        super(json);
        ProtonServerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        ProtonServerOptionsConverter.toJson(this, json);
        return json;
    }

    public ProtonServerOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    public ProtonServerOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public ProtonServerOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    public ProtonServerOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    public ProtonServerOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    public ProtonServerOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    public ProtonServerOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    public ProtonServerOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    public ProtonServerOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    public ProtonServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public ProtonServerOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    public ProtonServerOptions setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    public ProtonServerOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    public ProtonServerOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    public ProtonServerOptions setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }

    public ProtonServerOptions setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    public ProtonServerOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    public ProtonServerOptions addCrlPath(String crlPath) throws NullPointerException {
        super.addCrlPath(crlPath);
        return this;
    }

    public ProtonServerOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        super.addCrlValue(crlValue);
        return this;
    }

    public ProtonServerOptions setAcceptBacklog(int acceptBacklog) {
        super.setAcceptBacklog(acceptBacklog);
        return this;
    }

    public ProtonServerOptions setPort(int port) {
        super.setPort(port);
        return this;
    }

    public ProtonServerOptions setHost(String host) {
        super.setHost(host);
        return this;
    }

    @Deprecated
    public ProtonServerOptions setClientAuthRequired(boolean clientAuthRequired) {
        super.setClientAuthRequired(clientAuthRequired);
        return this;
    }

    public ProtonServerOptions setClientAuth(ClientAuth clientAuth) {
        super.setClientAuth(clientAuth);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.heartbeat;
        result = 31 * result + this.maxFrameSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ProtonServerOptions other = (ProtonServerOptions)((Object)obj);
        if (this.heartbeat != other.heartbeat) {
            return false;
        }
        return this.maxFrameSize == other.maxFrameSize;
    }

    public ProtonServerOptions setUseAlpn(boolean useAlpn) {
        throw new UnsupportedOperationException();
    }

    public ProtonServerOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public ProtonServerOptions removeEnabledSecureTransportProtocol(String protocol) {
        super.removeEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public ProtonServerOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
        return this;
    }

    public ProtonServerOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        super.setJdkSslEngineOptions(sslEngineOptions);
        return this;
    }

    public ProtonServerOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    public ProtonServerOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        super.setOpenSslEngineOptions(sslEngineOptions);
        return this;
    }

    public ProtonServerOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        super.setSslEngineOptions(sslEngineOptions);
        return this;
    }

    public ProtonServerOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    public ProtonServerOptions setLogActivity(boolean logEnabled) {
        super.setLogActivity(logEnabled);
        return this;
    }

    public ProtonServerOptions setSni(boolean sni) {
        super.setSni(sni);
        return this;
    }

    public ProtonServerOptions setReusePort(boolean reusePort) {
        super.setReusePort(reusePort);
        return this;
    }

    public ProtonServerOptions setTcpFastOpen(boolean tcpFastOpen) {
        super.setTcpFastOpen(tcpFastOpen);
        return this;
    }

    public ProtonServerOptions setTcpCork(boolean tcpCork) {
        super.setTcpCork(tcpCork);
        return this;
    }

    public ProtonServerOptions setTcpQuickAck(boolean tcpQuickAck) {
        super.setTcpQuickAck(tcpQuickAck);
        return this;
    }

    public ProtonServerOptions setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
        return this;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public ProtonServerOptions setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize < 0 ? -1 : maxFrameSize;
        return this;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }
}

