/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.ext.eventbus.bridge.tcp.BridgeEvent;

class BridgeEventImpl
implements BridgeEvent {
    private final BridgeEventType type;
    private final JsonObject rawMessage;
    private final NetSocket socket;
    private Future<Boolean> future;

    public BridgeEventImpl(BridgeEventType type, JsonObject rawMessage, NetSocket socket) {
        this.type = type;
        this.rawMessage = rawMessage;
        this.socket = socket;
    }

    public BridgeEventType type() {
        return this.type;
    }

    public JsonObject getRawMessage() {
        return this.rawMessage;
    }

    @Override
    public BridgeEvent setRawMessage(JsonObject message) {
        if (message != this.rawMessage) {
            this.rawMessage.clear().mergeIn(message);
        }
        return this;
    }

    public void handle(AsyncResult<Boolean> asyncResult) {
        this.future.handle(asyncResult);
    }

    @Override
    public NetSocket socket() {
        return this.socket;
    }

    public void setFuture(Future<Boolean> future) {
        this.future = future;
    }

    public boolean isComplete() {
        return this.future.isComplete();
    }

    public Future<Boolean> setHandler(Handler<AsyncResult<Boolean>> handler) {
        this.future.setHandler(handler);
        return this;
    }

    public void complete(Boolean result) {
        this.future.complete((Object)result);
    }

    public void complete() {
        this.future.complete();
    }

    public void fail(Throwable throwable) {
        this.future.fail(throwable);
    }

    public void fail(String failureMessage) {
        this.future.fail(failureMessage);
    }

    public boolean tryComplete(Boolean result) {
        return this.future.tryComplete((Object)result);
    }

    public boolean tryComplete() {
        return this.future.tryComplete();
    }

    public boolean tryFail(Throwable cause) {
        return this.future.tryFail(cause);
    }

    public boolean tryFail(String failureMessage) {
        return this.future.tryFail(failureMessage);
    }

    public Boolean result() {
        return (Boolean)this.future.result();
    }

    public Throwable cause() {
        return this.future.cause();
    }

    public boolean succeeded() {
        return this.future.succeeded();
    }

    public boolean failed() {
        return this.future.failed();
    }
}

