/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.mongo.AuthenticationException;
import io.vertx.ext.auth.mongo.HashAlgorithm;
import io.vertx.ext.auth.mongo.HashSaltStyle;
import io.vertx.ext.auth.mongo.HashStrategy;
import io.vertx.ext.auth.mongo.MongoAuth;
import io.vertx.ext.auth.mongo.impl.DefaultHashStrategy;
import io.vertx.ext.auth.mongo.impl.MongoUser;
import io.vertx.ext.mongo.MongoClient;
import java.util.List;

public class MongoAuthImpl
implements MongoAuth {
    private static final Logger log = LoggerFactory.getLogger(MongoAuthImpl.class);
    private MongoClient mongoClient;
    private String usernameField = "username";
    private String passwordField = "password";
    private String roleField = "roles";
    private String permissionField = "permissions";
    private String usernameCredentialField = "username";
    private String passwordCredentialField = "password";
    private String saltField = "salt";
    private String collectionName = "user";
    private JsonObject config;
    private HashStrategy hashStrategy;

    public MongoAuthImpl(MongoClient mongoClient, JsonObject config) {
        this.mongoClient = mongoClient;
        this.config = config;
        this.init();
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        String username = authInfo.getString(this.usernameCredentialField);
        String password = authInfo.getString(this.passwordCredentialField);
        if (username == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"Username must be set for authentication."));
            return;
        }
        if (password == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"Password must be set for authentication."));
            return;
        }
        AuthToken token = new AuthToken(username, password);
        JsonObject query = this.createQuery(username);
        this.mongoClient.find(this.collectionName, query, res -> {
            try {
                if (res.succeeded()) {
                    User user = this.handleSelection((AsyncResult<List<JsonObject>>)res, token);
                    resultHandler.handle((Object)Future.succeededFuture((Object)user));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                }
            }
            catch (Throwable e) {
                log.warn((Object)e);
                resultHandler.handle((Object)Future.failedFuture((Throwable)e));
            }
        });
    }

    protected JsonObject createQuery(String username) {
        return new JsonObject().put(this.usernameField, username);
    }

    private User handleSelection(AsyncResult<List<JsonObject>> resultList, AuthToken authToken) throws AuthenticationException {
        switch (((List)resultList.result()).size()) {
            case 0: {
                String message = "No account found for user [" + authToken.username + "]";
                throw new AuthenticationException(message);
            }
            case 1: {
                JsonObject json = (JsonObject)((List)resultList.result()).get(0);
                MongoUser user = new MongoUser(json, (MongoAuth)this);
                if (this.examinePassword((User)user, authToken)) {
                    return user;
                }
                String message = "Invalid username/password [" + authToken.username + "]";
                throw new AuthenticationException(message);
            }
        }
        String message = "More than one user row found for user [" + authToken.username + "( " + ((List)resultList.result()).size() + " )]. Usernames must be unique.";
        throw new AuthenticationException(message);
    }

    @Override
    public void insertUser(String username, String password, List<String> roles, List<String> permissions, Handler<AsyncResult<String>> resultHandler) {
        JsonObject principal = new JsonObject();
        principal.put(this.getUsernameField(), username);
        if (roles != null) {
            principal.put(this.roleField, new JsonArray(roles));
        }
        if (permissions != null) {
            principal.put(this.permissionField, new JsonArray(permissions));
        }
        MongoUser user = new MongoUser(principal, (MongoAuth)this);
        if (this.getHashStrategy().getSaltStyle() == HashSaltStyle.COLUMN) {
            principal.put(this.getSaltField(), DefaultHashStrategy.generateSalt());
        }
        String cryptPassword = this.getHashStrategy().computeHash(password, (User)user);
        principal.put(this.getPasswordField(), cryptPassword);
        this.mongoClient.save(this.getCollectionName(), user.principal(), resultHandler);
    }

    private boolean examinePassword(User user, AuthToken authToken) {
        String storedPassword = this.getHashStrategy().getStoredPwd(user);
        String givenPassword = this.getHashStrategy().computeHash(authToken.password, user);
        return storedPassword != null && storedPassword.equals(givenPassword);
    }

    private void init() {
        String saltstyle;
        String saltField;
        String passwordCredField;
        String usernameCredField;
        String permissionField;
        String roleField;
        String passwordField;
        String usernameField;
        String collectionName = this.config.getString("collectionName");
        if (collectionName != null) {
            this.setCollectionName(collectionName);
        }
        if ((usernameField = this.config.getString("usernameField")) != null) {
            this.setUsernameField(usernameField);
        }
        if ((passwordField = this.config.getString("passwordField")) != null) {
            this.setPasswordField(passwordField);
        }
        if ((roleField = this.config.getString("roleField")) != null) {
            this.setRoleField(roleField);
        }
        if ((permissionField = this.config.getString("permissionField")) != null) {
            this.setPermissionField(permissionField);
        }
        if ((usernameCredField = this.config.getString("usernameCredentialField")) != null) {
            this.setUsernameCredentialField(usernameCredField);
        }
        if ((passwordCredField = this.config.getString("passwordCredentialField")) != null) {
            this.setPasswordCredentialField(passwordCredField);
        }
        if ((saltField = this.config.getString("saltField")) != null) {
            this.setSaltField(saltField);
        }
        if ((saltstyle = this.config.getString("saltStyle")) != null) {
            this.getHashStrategy().setSaltStyle(HashSaltStyle.valueOf(saltstyle));
        }
    }

    @Override
    public MongoAuth setCollectionName(String collectionName) {
        this.collectionName = collectionName;
        return this;
    }

    @Override
    public MongoAuth setUsernameField(String fieldName) {
        this.usernameField = fieldName;
        return this;
    }

    @Override
    public MongoAuth setPasswordField(String fieldName) {
        this.passwordField = fieldName;
        return this;
    }

    @Override
    public MongoAuth setRoleField(String fieldName) {
        this.roleField = fieldName;
        return this;
    }

    @Override
    public MongoAuth setUsernameCredentialField(String fieldName) {
        this.usernameCredentialField = fieldName;
        return this;
    }

    @Override
    public MongoAuth setPasswordCredentialField(String fieldName) {
        this.passwordCredentialField = fieldName;
        return this;
    }

    @Override
    public MongoAuth setSaltField(String fieldName) {
        this.saltField = fieldName;
        return this;
    }

    @Override
    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public final String getUsernameField() {
        return this.usernameField;
    }

    @Override
    public final String getPasswordField() {
        return this.passwordField;
    }

    @Override
    public final String getRoleField() {
        return this.roleField;
    }

    @Override
    public final String getUsernameCredentialField() {
        return this.usernameCredentialField;
    }

    @Override
    public final String getPasswordCredentialField() {
        return this.passwordCredentialField;
    }

    @Override
    public final String getSaltField() {
        return this.saltField;
    }

    @Override
    public MongoAuth setPermissionField(String fieldName) {
        this.permissionField = fieldName;
        return this;
    }

    @Override
    public String getPermissionField() {
        return this.permissionField;
    }

    @Override
    public MongoAuth setHashStrategy(HashStrategy hashStrategy) {
        this.hashStrategy = hashStrategy;
        return this;
    }

    @Override
    public HashStrategy getHashStrategy() {
        if (this.hashStrategy == null) {
            this.hashStrategy = new DefaultHashStrategy();
        }
        return this.hashStrategy;
    }

    @Override
    public MongoAuth setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.getHashStrategy().setAlgorithm(hashAlgorithm);
        return this;
    }

    public String toString() {
        return String.valueOf(this.hashStrategy);
    }

    static class AuthToken {
        String username;
        String password;

        AuthToken(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

