/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.cassandra.CassandraRowStream;
import io.vertx.cassandra.ResultSet;
import io.vertx.cassandra.impl.CassandraClientImpl;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.UUID;

@VertxGen
public interface CassandraClient {
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";

    public static CassandraClient createNonShared(Vertx vertx) {
        return CassandraClient.createNonShared(vertx, new CassandraClientOptions());
    }

    public static CassandraClient createNonShared(Vertx vertx, CassandraClientOptions cassandraClientOptions) {
        return new CassandraClientImpl(vertx, UUID.randomUUID().toString(), cassandraClientOptions);
    }

    public static CassandraClient createShared(Vertx vertx) {
        return CassandraClient.createShared(vertx, DEFAULT_POOL_NAME);
    }

    public static CassandraClient createShared(Vertx vertx, String datasourceName) {
        return CassandraClient.createShared(vertx, datasourceName, new CassandraClientOptions());
    }

    public static CassandraClient createShared(Vertx vertx, CassandraClientOptions cassandraClientOptions) {
        return CassandraClient.createShared(vertx, DEFAULT_POOL_NAME, cassandraClientOptions);
    }

    public static CassandraClient createShared(Vertx vertx, String datasourceName, CassandraClientOptions cassandraClientOptions) {
        return new CassandraClientImpl(vertx, datasourceName, cassandraClientOptions);
    }

    @Fluent
    public CassandraClient connect();

    public boolean isConnected();

    @Fluent
    public CassandraClient connect(Handler<AsyncResult<Void>> var1);

    @Fluent
    public CassandraClient connect(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public CassandraClient executeWithFullFetch(String var1, Handler<AsyncResult<List<Row>>> var2);

    @Fluent
    public CassandraClient executeWithFullFetch(Statement var1, Handler<AsyncResult<List<Row>>> var2);

    @Fluent
    public CassandraClient execute(String var1, Handler<AsyncResult<ResultSet>> var2);

    @Fluent
    public CassandraClient execute(Statement var1, Handler<AsyncResult<ResultSet>> var2);

    @Fluent
    public CassandraClient prepare(String var1, Handler<AsyncResult<PreparedStatement>> var2);

    @Fluent
    public CassandraClient queryStream(String var1, Handler<AsyncResult<CassandraRowStream>> var2);

    @Fluent
    public CassandraClient queryStream(Statement var1, Handler<AsyncResult<CassandraRowStream>> var2);

    @Fluent
    public CassandraClient disconnect();

    @Fluent
    public CassandraClient disconnect(Handler<AsyncResult<Void>> var1);
}

