/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import io.vertx.cassandra.CassandraRowStream;
import io.vertx.cassandra.impl.Util;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.streams.impl.InboundBuffer;
import java.util.Iterator;

public class CassandraRowStreamImpl
implements CassandraRowStream {
    private final ResultSet datastaxResultSet;
    private final Iterator<Row> resultSetIterator;
    private final InboundBuffer<Row> internalQueue;
    private final Context context;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;

    public CassandraRowStreamImpl(ResultSet result, Context context) {
        this.datastaxResultSet = result;
        this.resultSetIterator = result.iterator();
        this.internalQueue = new InboundBuffer(context).drainHandler(v -> this.fire());
        this.context = context;
    }

    @Override
    public CassandraRowStream exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        this.internalQueue.exceptionHandler(handler);
        return this;
    }

    @Override
    public CassandraRowStream handler(Handler<Row> handler) {
        this.internalQueue.handler(handler);
        this.fire();
        return this;
    }

    @Override
    public CassandraRowStream pause() {
        this.internalQueue.pause();
        return this;
    }

    @Override
    public CassandraRowStream resume() {
        this.internalQueue.resume();
        return this;
    }

    @Override
    public synchronized CassandraRowStream endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        this.tryToTriggerEndOfTheStream();
        return this;
    }

    @Override
    public synchronized CassandraRowStream fetch(long l) {
        this.internalQueue.fetch(l);
        return this;
    }

    private synchronized void fire() {
        int availableWithoutFetching = this.datastaxResultSet.getAvailableWithoutFetching();
        boolean isFetched = this.datastaxResultSet.isFullyFetched();
        if (availableWithoutFetching != 0) {
            for (int i = 0; i < availableWithoutFetching && this.internalQueue.write((Object)this.resultSetIterator.next()); ++i) {
            }
            if (this.internalQueue.isWritable()) {
                this.fetchAndCallOneMoreTime();
            }
        } else if (isFetched) {
            this.tryToTriggerEndOfTheStream();
        } else {
            this.fetchAndCallOneMoreTime();
        }
    }

    private void fetchAndCallOneMoreTime() {
        if (this.datastaxResultSet.isFullyFetched()) {
            this.fire();
            return;
        }
        Util.handleOnContext(this.datastaxResultSet.fetchMoreResults(), this.context, ar -> {
            if (ar.succeeded()) {
                this.fire();
            } else {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.handle((Object)ar.cause());
                }
                if (this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            }
        });
    }

    private void tryToTriggerEndOfTheStream() {
        if (this.endHandler != null && this.datastaxResultSet.isFullyFetched() && !this.resultSetIterator.hasNext()) {
            this.endHandler.handle(null);
        }
    }
}

