/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ClassFilter;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.util.StringUtil;

public final class JavaSerializationFilterConfig {
    private final ClassFilter blacklist;
    private final ClassFilter whitelist;

    private JavaSerializationFilterConfig(ClassFilter blacklist, ClassFilter whitelist) {
        if (blacklist == null) {
            blacklist = new ClassFilter();
            blacklist.addClasses("com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl", "bsh.XThis", "org.apache.commons.beanutils.BeanComparator", "org.codehaus.groovy.runtime.ConvertedClosure", "org.codehaus.groovy.runtime.MethodClosure", "org.springframework.beans.factory.ObjectFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl").addPackages("org.apache.commons.collections.functors", "org.apache.commons.collections4.functors");
        }
        this.blacklist = blacklist;
        this.whitelist = whitelist == null ? new ClassFilter() : whitelist;
    }

    public static JavaSerializationFilterConfig getInstance(HazelcastProperties hzProperties) {
        if (hzProperties.getBoolean(GroupProperty.SERIALIZATION_FILTER_ENABLED)) {
            return new JavaSerializationFilterConfig(JavaSerializationFilterConfig.createClassFilter(hzProperties.getString(GroupProperty.SERIALIZATION_FILTER_BLACKLIST_CLASSES), hzProperties.getString(GroupProperty.SERIALIZATION_FILTER_BLACKLIST_PACKAGES)), JavaSerializationFilterConfig.createClassFilter(hzProperties.getString(GroupProperty.SERIALIZATION_FILTER_WHITELIST_CLASSES), hzProperties.getString(GroupProperty.SERIALIZATION_FILTER_WHITELIST_PACKAGES)));
        }
        return null;
    }

    public ClassFilter getBlacklist() {
        return this.blacklist;
    }

    public ClassFilter getWhitelist() {
        return this.whitelist;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.blacklist == null ? 0 : this.blacklist.hashCode());
        result = 31 * result + (this.whitelist == null ? 0 : this.whitelist.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JavaSerializationFilterConfig other = (JavaSerializationFilterConfig)obj;
        return (this.blacklist == null && other.blacklist == null || this.blacklist != null && this.blacklist.equals(other.blacklist)) && (this.whitelist == null && other.whitelist == null || this.whitelist != null && this.whitelist.equals(other.whitelist));
    }

    public String toString() {
        return "JavaSerializationFilterConfig{ blacklist=" + this.blacklist + ", whitelist=" + this.whitelist + "}";
    }

    private static ClassFilter createClassFilter(String csvClasses, String csvPackages) {
        if (StringUtil.isNullOrEmpty(csvClasses) && StringUtil.isNullOrEmpty(csvPackages)) {
            return null;
        }
        ClassFilter classFilter = new ClassFilter();
        classFilter.addClasses(StringUtil.splitByComma(csvClasses, false)).addPackages(StringUtil.splitByComma(csvPackages, false));
        return classFilter;
    }
}

