/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.spring;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.Objects;

class SpringConfigServerStore
implements ConfigStore {
    private final String path;
    private final String authHeaderValue;
    private final HttpClient client;
    private final long timeout;

    SpringConfigServerStore(Vertx vertx, JsonObject configuration) {
        String url = configuration.getString("url");
        this.timeout = configuration.getLong("timeout", Long.valueOf(3000L));
        Objects.requireNonNull(url);
        HttpClientOptions options = new HttpClientOptions(configuration.getJsonObject("httpClientConfiguration", new JsonObject()));
        try {
            URL u = new URL(url);
            options.setDefaultHost(u.getHost());
            if (u.getPort() == -1) {
                options.setDefaultPort(u.getDefaultPort());
            } else {
                options.setDefaultPort(u.getPort());
            }
            this.path = u.getPath() != null ? u.getPath() : "/";
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid url for the spring server: " + url);
        }
        this.authHeaderValue = configuration.getString("user") != null && configuration.getString("password") != null ? "Basic " + Base64.getEncoder().encodeToString((configuration.getString("user") + ":" + configuration.getString("password")).getBytes()) : null;
        this.client = vertx.createHttpClient(options);
    }

    public void close(Handler<Void> completionHandler) {
        if (this.client != null) {
            this.client.close();
        }
        completionHandler.handle(null);
    }

    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        HttpClientRequest request = this.client.get(this.path, response -> {
            if (response.statusCode() != 200) {
                completionHandler.handle((Object)Future.failedFuture((String)("Invalid response from server: " + response.statusCode() + " - " + response.statusMessage())));
            } else {
                response.exceptionHandler(t -> completionHandler.handle((Object)Future.failedFuture((Throwable)t))).bodyHandler(buffer -> this.parse(buffer.toJsonObject(), completionHandler));
            }
        }).setTimeout(this.timeout).exceptionHandler(t -> completionHandler.handle((Object)Future.failedFuture((Throwable)t)));
        if (this.authHeaderValue != null) {
            request.putHeader("Authorization", this.authHeaderValue);
        }
        request.end();
    }

    private void parse(JsonObject body, Handler<AsyncResult<Buffer>> handler) {
        if (this.path.endsWith(".json")) {
            this.parseFromJson(body, handler);
        } else {
            this.parseFromStandard(body, handler);
        }
    }

    private void parseFromStandard(JsonObject body, Handler<AsyncResult<Buffer>> handler) {
        JsonArray sources = body.getJsonArray("propertySources");
        if (sources == null) {
            handler.handle((Object)Future.failedFuture((String)"Invalid configuration server response, property sources missing"));
        } else {
            JsonObject configuration = new JsonObject();
            for (int i = sources.size() - 1; i >= 0; --i) {
                JsonObject source = sources.getJsonObject(i);
                JsonObject content = source.getJsonObject("source");
                configuration = configuration.mergeIn(content);
            }
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)configuration.encode())));
        }
    }

    private void parseFromJson(JsonObject body, Handler<AsyncResult<Buffer>> handler) {
        if (body == null) {
            handler.handle((Object)Future.failedFuture((String)"Invalid configuration server response, property sources missing"));
        } else {
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)body.encode())));
        }
    }
}

