/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.common.TopicAndPartition;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonValue;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class PreferredReplicaLeaderElectionCommand$
implements Logging {
    public static PreferredReplicaLeaderElectionCommand$ MODULE$;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new PreferredReplicaLeaderElectionCommand$();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PreferredReplicaLeaderElectionCommand$ preferredReplicaLeaderElectionCommand$ = this;
        synchronized (preferredReplicaLeaderElectionCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec jsonFileOpt = parser.accepts("path-to-json-file", "The JSON file with the list of partitions for which preferred replica leader election should be done, in the following format - \n{\"partitions\":\n\t[{\"topic\": \"foo\", \"partition\": 1},\n\t {\"topic\": \"foobar\", \"partition\": 2}]\n}\nDefaults to all existing partitions").withRequiredArg().describedAs("list of partitions for which preferred replica leader election needs to be triggered").ofType(String.class);
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "This tool causes leadership for each partition to be transferred back to the 'preferred replica', it can be used to balance leadership among the servers.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt}));
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        ZkUtils zkUtils = null;
        try (ZkClient zkClient = null;){
            try {
                zkClient = ZkUtils$.MODULE$.createZkClient(zkConnect, 30000, 30000);
                zkUtils = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());
                Set<TopicAndPartition> partitionsForPreferredReplicaElection = !options.has((OptionSpec)jsonFileOpt) ? zkUtils.getAllPartitions() : this.parsePreferredReplicaElectionData(Utils.readFileAsString((String)((String)options.valueOf((OptionSpec)jsonFileOpt))));
                PreferredReplicaLeaderElectionCommand preferredReplicaElectionCommand = new PreferredReplicaLeaderElectionCommand(zkUtils, partitionsForPreferredReplicaElection);
                preferredReplicaElectionCommand.moveLeaderToPreferredReplica();
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)"Failed to start preferred replica election");
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            }
        }
    }

    public scala.collection.immutable.Set<TopicAndPartition> parsePreferredReplicaElectionData(String jsonString) {
        scala.collection.immutable.Set set;
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Buffer partitions;
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.value();
            Option<JsonValue> option2 = js.asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                JsonValue partitionsList = (JsonValue)some2.value();
                Iterator partitionsRaw = partitionsList.asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject());
                partitions = partitionsRaw.map((Function1 & Serializable & scala.Serializable)p -> {
                    String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    int partition = BoxesRunTime.unboxToInt((Object)p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                    return new TopicAndPartition(topic, partition);
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (duplicatePartitions.nonEmpty()) {
                    throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Preferred replica election data contains duplicate partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
                }
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new AdminOperationException("Preferred replica election data is empty");
                }
                throw new MatchError(option2);
            }
            set = partitions.toSet();
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new AdminOperationException("Preferred replica election data is empty");
            }
            throw new MatchError(option);
        }
        scala.collection.immutable.Set set2 = set;
        return set2;
    }

    public void writePreferredReplicaElectionData(ZkUtils zkUtils, Set<TopicAndPartition> partitionsUndergoingPreferredReplicaElection) {
        String zkPath = ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath();
        String jsonData = ZkUtils$.MODULE$.preferredReplicaLeaderElectionZkData(partitionsUndergoingPreferredReplicaElection);
        try {
            zkUtils.createPersistentPath(zkPath, jsonData, zkUtils.createPersistentPath$default$3());
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Created preferred replica election path with %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jsonData})));
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            scala.collection.immutable.Set<TopicAndPartition> partitionsUndergoingPreferredReplicaElection2 = this.parsePreferredReplicaElectionData((String)zkUtils.readData(zkPath)._1());
            throw new AdminOperationException("Preferred replica leader election currently in progress for " + new StringOps(Predef$.MODULE$.augmentString("%s. Aborting operation")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsUndergoingPreferredReplicaElection2})));
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    private PreferredReplicaLeaderElectionCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

